<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SchoolNext Dashboard</title>
    <style>
        :root {
            --bg: #f4f6f8;
            --panel: #ffffff;
            --ink: #1d2b38;
            --muted: #607181;
            --accent: #006d77;
            --line: #d8e1e8;
        }

        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: "Segoe UI", Tahoma, sans-serif;
            background: radial-gradient(circle at 10% 10%, #e6f4f1, var(--bg));
            color: var(--ink);
        }

        .wrap {
            max-width: 1100px;
            margin: 0 auto;
            padding: 28px 18px 40px;
        }

        .head {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 16px;
            margin-bottom: 18px;
        }

        h1 {
            margin: 0;
            font-size: 28px;
            letter-spacing: 0.2px;
        }

        .sub {
            margin: 4px 0 0;
            color: var(--muted);
            font-size: 14px;
        }

        .badge {
            background: var(--panel);
            border: 1px solid var(--line);
            border-left: 4px solid var(--accent);
            padding: 8px 12px;
            border-radius: 10px;
            font-size: 13px;
            color: var(--muted);
            white-space: nowrap;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(4, minmax(0, 1fr));
            gap: 12px;
            margin-bottom: 18px;
        }

        .card {
            background: var(--panel);
            border: 1px solid var(--line);
            border-radius: 12px;
            padding: 14px;
        }

        .card .k {
            font-size: 12px;
            color: var(--muted);
            text-transform: uppercase;
            letter-spacing: 0.7px;
            margin-bottom: 8px;
        }

        .card .v {
            font-size: 28px;
            font-weight: 700;
            line-height: 1;
            color: var(--accent);
        }

        .table-panel {
            background: var(--panel);
            border: 1px solid var(--line);
            border-radius: 12px;
            overflow: hidden;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            padding: 11px 14px;
            border-bottom: 1px solid #edf2f6;
            font-size: 14px;
            text-align: left;
        }

        th {
            background: #f9fbfc;
            color: var(--muted);
            font-weight: 600;
        }

        tr:last-child td { border-bottom: 0; }

        @media (max-width: 900px) {
            .grid { grid-template-columns: repeat(2, minmax(0, 1fr)); }
        }

        @media (max-width: 560px) {
            .head { flex-direction: column; align-items: flex-start; }
            .grid { grid-template-columns: 1fr; }
            .card .v { font-size: 24px; }
        }
    </style>
</head>
<body>
    <main class="wrap">
        <section class="head">
            <div>
                <h1>SchoolNext Dashboard</h1>
                <p class="sub">Proyecto Laravel nuevo conectado a la BD consolidada.</p>
            </div>
            <div class="badge">DB: <strong>windsor1_schoolnext_prod</strong></div>
        </section>

        <section class="grid">
            @foreach($cards as $label => $value)
                <article class="card">
                    <div class="k">{{ $label }}</div>
                    <div class="v">{{ number_format($value, 0, ',', '.') }}</div>
                </article>
            @endforeach
        </section>

        <section class="table-panel">
            <table>
                <thead>
                    <tr>
                        <th>Año</th>
                        <th>Total de notas</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($annioRows as $row)
                        <tr>
                            <td>{{ $row->annio }}</td>
                            <td>{{ number_format($row->total, 0, ',', '.') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </section>
    </main>
</body>
</html>
