@extends('admin.layouts.app')

@section('title', 'Detalle de Profesor')
@section('page_title', 'Detalle de Profesor')

@section('content')
    @php
        $photo = trim((string) ($teacher->photo ?? ''));
        $hasPhotoPath = $photo !== '' && (str_contains($photo, '/') || str_contains($photo, '.'));
    @endphp
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-size:38px; font-size:36px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:8px; }
        .hint { background:#f2e3b6; border:1px solid #d5c38f; padding:8px 10px; margin:8px; color:#000; }
        .req-note { text-align:right; color:#d98b00; font-style:italic; padding-right:4px; }
        .section { border:1px solid #d1d7dc; background:#f8f8f8; padding:10px; margin:8px; }
        .grid { display:grid; grid-template-columns: 1fr 1fr 210px; gap:14px; }
        .field { margin-bottom:8px; }
        .field label { display:block; font-weight:700; font-size:14px; margin-bottom:2px; }
        .field input, .field select { width:100%; height:30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .req { color:#d98b00; }
        .photo-box img, .photo-box .empty { width:100%; max-width:210px; height:275px; border:1px solid #c1c8ce; object-fit:cover; background:#f0f0f0; margin:0 auto 10px; display:block; }
        .photo-box .empty {
            background:linear-gradient(180deg,#eef2f6,#dde4ea);
            position:relative;
        }
        .photo-box .empty::before {
            content:"";
            position:absolute;
            width:66px;
            height:66px;
            border-radius:50%;
            background:#c0c7cf;
            top:52px;
            left:50%;
            transform:translateX(-50%);
        }
        .photo-box .empty::after {
            content:"";
            position:absolute;
            width:108px;
            height:92px;
            border-radius:60px 60px 8px 8px;
            background:#c0c7cf;
            bottom:28px;
            left:50%;
            transform:translateX(-50%);
        }
        .gender { display:flex; gap:18px; align-items:center; padding-top:4px; }
        .system-title { color:#0b6c0b; font-weight:800; letter-spacing:8px; text-transform:lowercase; font-size:34px; font-size:30px; margin:0 0 10px; }
        .system-row { display:grid; grid-template-columns: 170px 1fr; gap:8px; margin-bottom:6px; align-items:start; }
        .system-row .k { font-weight:700; }
        .sys-code { font-family: Consolas, monospace; font-size:30px; font-size:27px; color:#000; }
        .btn-legacy {
            background:#d9a10c;
            border:1px solid #9a7205;
            color:#fff;
            font-weight:700;
            min-width:110px;
            width:auto;
            height:32px;
            border-radius:6px;
            cursor:pointer;
            padding:0 18px;
            display:inline-flex;
            align-items:center;
            justify-content:center;
            white-space:nowrap;
            text-decoration:none;
        }
        .footer-actions { text-align:center; margin:12px 0 10px; display:flex; justify-content:center; gap:18px; align-items:center; }
        .small-muted { color:#3e4e59; font-size:13px; }
        @media (max-width: 1080px) {
            .grid { grid-template-columns:1fr; }
            .system-row { grid-template-columns:1fr; }
            .photo-box img, .photo-box .empty { max-width:280px; }
        }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main">Detalle de Profesor</h2>
        @if(session('status'))
            <div style="margin:0 8px 10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div style="margin:0 8px 10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <strong>Revisa estos campos:</strong>
                <ul style="margin:6px 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Profesor</div>
            <div class="box-body">
                <div class="req-note">* Requerido</div>
                <div class="hint">
                    Por favor no modifique la informacion de <strong>Nombres/Apellidos</strong> salvo para corregir dicha informacion del mismo
                    <strong>Profesor</strong>. Si necesita crear un nuevo Profesor puede usar el boton <strong>Agregar</strong> de la pantalla Profesores.
                </div>

                <form method="POST" action="{{ route('admin.profesores.update', ['id' => $teacher->id, 'annio' => $annio]) }}">
                    @csrf
                    <div class="section">
                        <div class="grid">
                            <div>
                                <div class="field">
                                    <label>Primer Nombre <span class="req">*</span></label>
                                    <input name="primer_nombre" value="{{ old('primer_nombre', $primerNombre) }}">
                                </div>
                                <div class="field">
                                    <label>Primer Apellido <span class="req">*</span></label>
                                    <input name="primer_apellido" value="{{ old('primer_apellido', $teacher->apellido1) }}">
                                </div>
                                <div class="field">
                                    <label>Fecha de Cumpleaños</label>
                                    <input type="date" name="fecha_nac" value="{{ old('fecha_nac', $teacher->fecha_nac) }}">
                                </div>
                                <div class="field">
                                    <label>Tipo de Documento</label>
                                    <select name="tipo_dcto">
                                        @foreach(['Cédula de Ciudadanía','Cédula de Extranjería','Pasaporte','Tarjeta de Identidad'] as $docType)
                                            <option value="{{ $docType }}" @selected(old('tipo_dcto', $tipoDcto) === $docType)>{{ $docType }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="field">
                                    <label>Dirección</label>
                                    <input name="direccion" value="{{ old('direccion', $teacher->direccion) }}">
                                </div>
                                <div class="field">
                                    <label>Telefono(s)</label>
                                    <input name="telefono1" value="{{ old('telefono1', $teacher->telefono1) }}">
                                </div>
                            </div>

                            <div>
                                <div class="field">
                                    <label>Segundo Nombre</label>
                                    <input name="segundo_nombre" value="{{ old('segundo_nombre', $segundoNombre) }}">
                                </div>
                                <div class="field">
                                    <label>Segundo Apellido</label>
                                    <input name="segundo_apellido" value="{{ old('segundo_apellido', $teacher->apellido2) }}">
                                </div>
                                <div class="field">
                                    <label>Genero</label>
                                    <div class="gender">
                                        <label><input type="radio" name="sexo" value="Masculino" @checked(old('sexo', $teacher->sexo) === 'Masculino')> Masculino</label>
                                        <label><input type="radio" name="sexo" value="Femenino" @checked(old('sexo', $teacher->sexo) === 'Femenino')> Femenino</label>
                                    </div>
                                </div>
                                <div class="field">
                                    <label>No. de Documento <span class="req">*</span></label>
                                    <input name="documento" value="{{ old('documento', $teacher->documento) }}">
                                </div>
                                <div class="field">
                                    <label>Dirección Email <span class="req">*</span></label>
                                    <input type="email" name="email" value="{{ old('email', $teacher->email) }}">
                                </div>
                                <div class="field">
                                    <label>Nombre de Usuario <span class="req">*</span></label>
                                    <input name="username" value="{{ old('username', $teacher->username) }}">
                                </div>
                            </div>

                            <div class="photo-box">
                                @if($hasPhotoPath)
                                    <img src="{{ asset('storage/' . $photo) }}" alt="Foto profesor">
                                @else
                                    <div class="empty"></div>
                                @endif
                                <div class="small-muted">La foto no esta disponible en este respaldo de BD.</div>
                                <div style="margin-top:8px;">
                                    <label><input type="checkbox" name="is_active" value="1" @checked((int)old('is_active', $teacher->is_active) === 1)> Usuario habilitado</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="section">
                        <h3 class="system-title">acceso al sistema</h3>
                        <div class="system-row">
                            <div class="k">Nombre de Usuario</div>
                            <div class="sys-code">{{ $teacher->username }}</div>
                        </div>
                        <div class="system-row">
                            <div class="k">Clave de Acceso</div>
                            <div>
                                Por motivos de seguridad las claves de acceso no son visibles para ningun usuario.
                                Si necesita restablecerla, ese flujo se habilitara en el siguiente paso.
                            </div>
                        </div>
                        <button type="button" class="btn-legacy">Restablecer</button>
                    </div>

                    <div class="footer-actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.profesores.index', ['annio' => $annio]) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

