﻿@extends('admin.layouts.app')

@section('title', 'Profesores')
@section('page_title', 'General - Profesores')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:16px 14px 22px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:10px 0 14px; font-weight:800; }
        .tools { display:flex; justify-content:center; gap:10px; margin-bottom:14px; flex-wrap:wrap; }
        .tools input { width:300px; height:30px; border:1px solid #08708e; background:#d9e7e7; padding:4px 8px; }
        .btn-legacy { background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700; min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 16px; }
        .table-box { border:2px solid #0e7a96; background:#fff; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        table { width:100%; border-collapse:collapse; }
        th, td { border:1px solid #95a5ad; padding:6px; font-size:14px; text-align:left; vertical-align:middle; }
        th { background:#d5dddd; font-weight:800; }
        tbody tr:nth-child(even) { background:#ccdbdd; }
        .person { display:flex; align-items:center; gap:10px; }
        .avatar, .avatar-empty { width:48px; height:62px; border:1px solid #b7c2ca; object-fit:cover; background:#e6ecef; display:block; }
        .avatar-empty {
            border-radius:4px;
            background:linear-gradient(180deg,#eef2f6,#dde4ea);
            position:relative;
        }
        .avatar-empty::before {
            content:"";
            position:absolute;
            width:18px;
            height:18px;
            border-radius:50%;
            background:#c0c7cf;
            top:10px;
            left:50%;
            transform:translateX(-50%);
        }
        .avatar-empty::after {
            content:"";
            position:absolute;
            width:28px;
            height:20px;
            border-radius:16px 16px 4px 4px;
            background:#c0c7cf;
            bottom:8px;
            left:50%;
            transform:translateX(-50%);
        }
        .name-link { color:#005c83; text-decoration:underline; text-underline-offset:2px; }
        .name-link:hover { color:#014d6d; }
        .tfoot { text-align:right; font-size:13px; margin-top:6px; color:#222; }
        .pager { margin-top:12px; display:flex; justify-content:center; gap:6px; flex-wrap:wrap; }
        .pager a, .pager span {
            border:1px solid #8da0ad; background:#fff; color:#0e2b3d; text-decoration:none;
            padding:4px 9px; border-radius:4px; font-size:13px; line-height:1.2;
        }
        .pager .active { background:#0e6f88; border-color:#0e6f88; color:#fff; font-weight:700; }
        .pager .disabled { opacity:.45; pointer-events:none; }
        .col-name { width:40%; }
        .col-dir { width:15%; }
        .col-phone { width:20%; }
        .col-user { width:25%; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Profesores</h2>
        @if(session('status'))
            <div style="margin:0 0 10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif

        <form class="tools ui-label" method="GET">
            <input type="hidden" name="annio" value="{{ $annio }}">
            <input type="text" name="q" value="{{ $q }}" placeholder="Buscar profesor por nombre, usuario o telefono">
            <button type="submit" class="btn-legacy">Buscar</button>
            <a href="{{ route('admin.profesores.create', ['annio' => $annio]) }}" class="btn-legacy" style="text-decoration:none;display:inline-flex;align-items:center;justify-content:center;">Agregar</a>
        </form>

        <div class="table-box">
            <div class="table-title ui-table-title">Profesores</div>
            <table>
                <thead>
                <tr>
                    <th class="col-name">Nombre</th>
                    <th class="col-dir">Director de</th>
                    <th class="col-phone">Telefono(s)</th>
                    <th class="col-user">Nombre de Usuario</th>
                </tr>
                </thead>
                <tbody>
                @forelse($rows as $r)
                    @php
                        $name = trim(($r->nombres ?? '') . ' ' . ($r->apellido1 ?? '') . ' ' . ($r->apellido2 ?? ''));
                        $photo = trim((string) ($r->photo ?? ''));
                        $hasPhotoPath = $photo !== '' && (str_contains($photo, '/') || str_contains($photo, '.'));
                    @endphp
                    <tr>
                        <td>
                            <div class="person">
                                @if($hasPhotoPath)
                                    <img class="avatar" src="{{ asset('storage/' . $photo) }}" alt="{{ $name !== '' ? $name : 'Profesor' }}">
                                @else
                                    <div class="avatar-empty"></div>
                                @endif
                                <a class="name-link" href="{{ route('admin.profesores.show', ['id' => $r->id, 'annio' => $annio]) }}">{{ $name !== '' ? $name : 'Sin nombre' }}</a>
                            </div>
                        </td>
                        <td>{{ $r->director_de !== '' ? $r->director_de : '-' }}</td>
                        <td>{{ $r->telefono1 ?: '-' }}</td>
                        <td>{{ $r->username ?: '-' }}</td>
                    </tr>
                @empty
                    <tr><td colspan="4">Sin profesores para los filtros aplicados.</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="tfoot">Total registros: {{ $rows->total() }}</div>

        <div class="pager">
            @if($rows->onFirstPage())
                <span class="disabled">&laquo; Anterior</span>
            @else
                <a href="{{ $rows->previousPageUrl() }}">&laquo; Anterior</a>
            @endif

            @for($page = 1; $page <= $rows->lastPage(); $page++)
                @if($page === 1 || $page === $rows->lastPage() || ($page >= $rows->currentPage()-2 && $page <= $rows->currentPage()+2))
                    @if($page === $rows->currentPage())
                        <span class="active">{{ $page }}</span>
                    @else
                        <a href="{{ $rows->url($page) }}">{{ $page }}</a>
                    @endif
                @elseif($page === $rows->currentPage()-3 || $page === $rows->currentPage()+3)
                    <span>...</span>
                @endif
            @endfor

            @if($rows->hasMorePages())
                <a href="{{ $rows->nextPageUrl() }}">Siguiente &raquo;</a>
            @else
                <span class="disabled">Siguiente &raquo;</span>
            @endif
        </div>
    </div>
@endsection

