@extends('admin.layouts.app')

@section('title', 'Detalle de Profesor')
@section('page_title', 'Detalle de Profesor')

@section('content')
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:8px; }
        .req-note { text-align:right; color:#d98b00; font-style:italic; padding-right:4px; }
        .section { border:1px solid #d1d7dc; background:#f8f8f8; padding:10px; margin:8px; }
        .grid { display:grid; grid-template-columns: 1fr 1fr; gap:14px; }
        .field { margin-bottom:8px; }
        .field label { display:block; font-weight:700; margin-bottom:2px; font-size: var(--fs-label-global); }
        .field input, .field select {
            width:100%;
            height:30px;
            border:1px solid #0a7391;
            background:#d9e7e7;
            padding:4px 8px;
            font-size: var(--fs-input-global);
        }
        .req { color:#d98b00; }
        .gender { display:flex; gap:18px; align-items:center; padding-top:4px; font-size: var(--fs-input-global); }
        .btn-legacy {
            background:#d9a10c;
            border:1px solid #9a7205;
            color:#fff;
            font-weight:700;
            min-width:110px;
            width:auto;
            height:32px;
            border-radius:6px;
            cursor:pointer;
            padding:0 18px;
            display:inline-flex;
            align-items:center;
            justify-content:center;
            white-space:nowrap;
            text-decoration:none;
            font-size: var(--fs-button-global);
        }
        .footer-actions { text-align:center; margin:12px 0 10px; display:flex; justify-content:center; gap:18px; align-items:center; }
        @media (max-width: 1080px) {
            .grid { grid-template-columns:1fr; }
        }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main ui-title">Detalle de Profesor</h2>
        @if ($errors->any())
            <div style="margin:0 8px 10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <strong>Revisa estos campos:</strong>
                <ul style="margin:6px 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Profesor</div>
            <div class="box-body">
                <div class="req-note">* Requerido</div>

                <form method="POST" action="{{ route('admin.profesores.store', ['annio' => $annio]) }}">
                    @csrf
                    <div class="section">
                        <div class="grid">
                            <div>
                                <div class="field">
                                    <label>Primer Nombre <span class="req">*</span></label>
                                    <input name="primer_nombre" value="{{ old('primer_nombre') }}">
                                </div>
                                <div class="field">
                                    <label>Primer Apellido <span class="req">*</span></label>
                                    <input name="primer_apellido" value="{{ old('primer_apellido') }}">
                                </div>
                                <div class="field">
                                    <label>Fecha de Cumpleaños</label>
                                    <input type="date" name="fecha_nac" value="{{ old('fecha_nac') }}">
                                </div>
                                <div class="field">
                                    <label>Tipo de Documento</label>
                                    <select name="tipo_dcto">
                                        @foreach(['Cédula de Ciudadanía','Cédula de Extranjería','Pasaporte','Tarjeta de Identidad'] as $docType)
                                            <option value="{{ $docType }}" @selected(old('tipo_dcto', 'Cédula de Ciudadanía') === $docType)>{{ $docType }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="field">
                                    <label>Dirección</label>
                                    <input name="direccion" value="{{ old('direccion') }}">
                                </div>
                                <div class="field">
                                    <label>Telefono(s)</label>
                                    <input name="telefono1" value="{{ old('telefono1') }}">
                                </div>
                                <div class="field">
                                    <label>Contraseña <span class="req">*</span></label>
                                    <input type="password" name="password">
                                </div>
                            </div>

                            <div>
                                <div class="field">
                                    <label>Segundo Nombre</label>
                                    <input name="segundo_nombre" value="{{ old('segundo_nombre') }}">
                                </div>
                                <div class="field">
                                    <label>Segundo Apellido</label>
                                    <input name="segundo_apellido" value="{{ old('segundo_apellido') }}">
                                </div>
                                <div class="field">
                                    <label>Género</label>
                                    <div class="gender">
                                        <label><input type="radio" name="sexo" value="Masculino" @checked(old('sexo') === 'Masculino')> Masculino</label>
                                        <label><input type="radio" name="sexo" value="Femenino" @checked(old('sexo', 'Femenino') === 'Femenino')> Femenino</label>
                                    </div>
                                </div>
                                <div class="field">
                                    <label>No. de Documento <span class="req">*</span></label>
                                    <input name="documento" value="{{ old('documento') }}">
                                </div>
                                <div class="field">
                                    <label>Dirección Email <span class="req">*</span></label>
                                    <input type="email" name="email" value="{{ old('email') }}">
                                </div>
                                <div class="field">
                                    <label>Nombre de Usuario <span class="req">*</span></label>
                                    <input name="username" value="{{ old('username') }}">
                                </div>
                                <div class="field" style="margin-top:26px;">
                                    <label><input type="checkbox" name="is_active" value="1" @checked((int) old('is_active', 1) === 1)> Usuario habilitado</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="footer-actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.profesores.index', ['annio' => $annio]) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
