@extends('admin.layouts.app')

@section('title', 'Detalle de Acudiente')
@section('page_title', 'Detalle de Acudiente')

@section('content')
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-size:26px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:14px; }
        .req-mark { float:right; color:#d98b00; font-style:italic; font-weight:700; margin-top:2px; }
        .note { background:#f2e1b6; border:1px solid #d8c08a; padding:8px; margin:12px 0; font-size:14px; }
        .grid-4 { display:grid; grid-template-columns: 1fr 1fr 1fr 1fr; gap:12px 20px; }
        .field label { display:block; font-weight:700; font-size:14px; margin-bottom:2px; }
        .field input, .field select { width:100%; height:30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .inline-radio { display:flex; gap:18px; align-items:center; padding-top:3px; }
        .section { border:1px solid #d1d7dc; background:#f8f8f8; padding:10px; margin-top:12px; }
        .section-title { margin:0 0 10px; color:#be8a07; font-weight:800; letter-spacing:6px; text-transform:uppercase; font-size:16px; }
        .filters { display:grid; grid-template-columns: 140px 1fr 130px 140px 140px 1fr; gap:8px; align-items:center; margin-bottom:10px; }
        .filters input { width:100%; height:30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .radio-row { display:flex; gap:18px; align-items:center; margin:6px 0 10px; }
        .btn-legacy {
            background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700;
            min-width:88px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px;
            display:inline-flex; align-items:center; justify-content:center; text-decoration:none;
            box-shadow:0 1px 0 rgba(255,255,255,.35) inset, 0 2px 6px rgba(0,0,0,.2);
        }
        .btn-row { text-align:center; margin:10px 0; display:flex; justify-content:center; gap:12px; }
        .family-note { background:#f6e8bf; border-top:1px solid #b4a378; border-bottom:1px solid #b4a378; padding:4px 8px; margin:8px 0 6px; font-style:italic; }
        .group-table, .member-table { width:100%; border-collapse:collapse; }
        .group-table th, .group-table td, .member-table th, .member-table td { border:1px solid #8fa2b2; padding:6px; font-size:14px; vertical-align:top; }
        .group-table th, .member-table th { background:#cfd8e0; text-align:left; }
        .footer-actions { text-align:center; margin-top:14px; display:flex; justify-content:center; gap:18px; align-items:center; }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main">Detalle de Acudiente</h2>

        @if(session('status'))
            <div style="margin-bottom:10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div style="margin-bottom:10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <strong>Revisa estos campos:</strong>
                <ul style="margin:6px 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Acudiente</div>
            <div class="box-body">
                <div class="req-mark">* Requerido</div>

                <div class="note">
                    Por favor no modifique la información de <strong>Nombres/Apellidos</strong> salvo para corregir dicha información del <strong>mismo Acudiente</strong>.
                    Si necesita crear un nuevo Acudiente puede hacer clic en el botón <strong>Agregar</strong> de la pantalla Acudientes.
                </div>

                <form method="POST" action="{{ route('admin.general.acudientes.update', ['id' => $record->id, 'annio' => $annio]) }}">
                    @csrf
                    <div class="grid-4">
                        <div class="field">
                            <label>Primer Nombre</label>
                            <input name="primer_nombre" value="{{ old('primer_nombre', $primerNombre) }}">
                        </div>
                        <div class="field">
                            <label>Segundo Nombre</label>
                            <input name="segundo_nombre" value="{{ old('segundo_nombre', $segundoNombre) }}">
                        </div>
                        <div class="field">
                            <label>Primer Apellido</label>
                            <input name="primer_apellido" value="{{ old('primer_apellido', $primerApellido) }}">
                        </div>
                        <div class="field">
                            <label>Segundo Apellido</label>
                            <input name="segundo_apellido" value="{{ old('segundo_apellido', $segundoApellido) }}">
                        </div>

                        <div class="field">
                            <label>Tipo de Documento</label>
                            <select>
                                <option>Cédula de Ciudadanía</option>
                            </select>
                        </div>
                        <div class="field">
                            <label>No. de Documento</label>
                            <input name="documento" value="{{ old('documento', $record->acudi_id) }}">
                        </div>
                        <div class="field">
                            <label>Género</label>
                            <div class="inline-radio">
                                <label><input type="radio" name="genero" value="Masculino" checked> Masculino</label>
                                <label><input type="radio" name="genero" value="Femenino"> Femenino</label>
                            </div>
                        </div>
                        <div class="field">
                            <label>Dirección</label>
                            <input name="direccion" value="{{ old('direccion', $record->acudi_dir) }}">
                        </div>

                        <div class="field">
                            <label>Teléfono(s)</label>
                            <input name="telefono" value="{{ old('telefono', $record->acudi_tel_1) }}">
                        </div>
                        <div class="field">
                            <label>Dirección Email</label>
                            <input name="email" value="{{ old('email', $record->acudi_email) }}">
                        </div>
                    </div>

                    <div class="section">
                        <h3 class="section-title">Grupos Familiares</h3>
                        <div style="margin-bottom:8px;color:#045f7a;">
                            Si es necesario, busque y seleccione los <strong>Grupos Familiares</strong> a los cuales pertenece este <strong>Acudiente</strong>:
                        </div>
                        <div class="filters">
                            <label>Nombres/Apellidos</label><input>
                            <label>No. de Documento</label><input>
                            <label>Código Estudiante</label><input>
                        </div>
                        <div class="radio-row">
                            <strong>Mostrar</strong>
                            <label><input type="radio" checked> Solo Grupos Familiares actuales</label>
                            <label><input type="radio"> Todos</label>
                            <button type="button" class="btn-legacy">Buscar</button>
                        </div>

                        <div class="family-note">(Mostrando máximo 5 grupos familiares. Afine los criterios de búsqueda para obtener mejores resultados)</div>
                        <table class="group-table">
                            <thead>
                                <tr>
                                    <th style="width:36px;"><input type="checkbox"></th>
                                    <th style="width:40%;">Grupo Familiar</th>
                                    <th>Detalle de Miembros</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($groups as $g)
                                    <tr>
                                        <td><input type="checkbox" @checked($loop->first)></td>
                                        <td><a href="#" style="color:#005c83;">{{ $g->group_name }}</a></td>
                                        <td>
                                            <table class="member-table">
                                                <thead>
                                                    <tr>
                                                        <th>Nombre</th>
                                                        <th style="width:150px;">Parentesco por defecto</th>
                                                        <th style="width:130px;">No. de Documento</th>
                                                        <th style="width:90px;">Código</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($g->members as $m)
                                                        @if(trim((string)($m['nombre'] ?? '')) !== '')
                                                            <tr>
                                                                <td>{{ $m['nombre'] }}</td>
                                                                <td>{{ $m['parentesco'] }}</td>
                                                                <td>{{ $m['documento'] ?: '-' }}</td>
                                                                <td>{{ $m['codigo'] ?: 'N/A' }}</td>
                                                            </tr>
                                                        @endif
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="3">Sin grupos familiares relacionados.</td></tr>
                                @endforelse
                            </tbody>
                        </table>

                        <div style="margin-top:10px;padding:8px;background:#ececec;border:1px solid #d5d5d5;display:flex;justify-content:space-between;align-items:center;gap:10px;">
                            <div>Puede hacer clic en el siguiente botón para crear un nuevo <strong>Grupo Familiar</strong> con este Acudiente como <strong>Acudiente Principal</strong>.</div>
                            <button type="button" class="btn-legacy">Agregar</button>
                        </div>
                    </div>

                    <div class="footer-actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.general.grupos.item', ['item' => 'acudientes', 'annio' => $annio]) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

