@extends('admin.layouts.app')

@section('title', $isCreate ? 'Detalle de Grado' : 'Detalle de Grado')
@section('page_title', 'Detalle de Grado')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; }
        .legacy-title { text-align:center; color:#00607f; margin:8px 0 14px; font-weight:800; }
        .box { border:2px solid #0e7a96; background:#fff; max-width:980px; margin:0 auto; }
        .box-head { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:14px; }
        .grid {
            display:grid;
            grid-template-columns: 180px minmax(220px, 1fr) 180px minmax(220px, 1fr);
            gap:10px 12px;
            align-items:center;
        }
        .grid label { font-weight:700; }
        .grid input, .grid select {
            background:#d9e7e7;
            border:1px solid #08708e;
            border-radius:0;
            height:32px;
            padding:4px 8px;
            width:100%;
        }
        .actions { display:flex; justify-content:center; gap:14px; margin-top:18px; }
        .btn-legacy {
            display:inline-flex; align-items:center; justify-content:center;
            min-width:90px; height:32px; padding:0 14px;
            border-radius:6px; border:1px solid #9a7205;
            background:#d9a10c; color:#fff; font-weight:700; text-decoration:none;
            box-shadow:0 1px 0 rgba(255,255,255,.35) inset, 0 2px 6px rgba(0,0,0,.2);
        }
        .msg-ok { max-width:980px; margin:0 auto 10px; padding:8px 10px; background:#e7f7ea; border:1px solid #9dd5aa; color:#125323; }
        .msg-err { max-width:980px; margin:0 auto 10px; padding:8px 10px; background:#ffecec; border:1px solid #f0a2a2; color:#7d1111; }
        @media (max-width:900px) {
            .grid { grid-template-columns: 1fr; }
        }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Detalle de Grado</h2>

        @if(session('status'))
            <div class="msg-ok">{{ session('status') }}</div>
        @endif
        @if($errors->any())
            <div class="msg-err">
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Grado</div>
            <div class="box-body">
                <form method="POST" action="{{ $isCreate ? route('admin.general.grados.store') : route('admin.general.grados.update', ['id' => $grado->id]) }}">
                    @csrf
                    <div class="grid ui-label">
                        <label for="nombre">Nombre</label>
                        <input id="nombre" name="nombre" value="{{ old('nombre', $grado->nombre) }}" required>

                        <label for="abrev">Abreviatura</label>
                        <input id="abrev" name="abrev" value="{{ old('abrev', $grado->abrev) }}" required>

                        <label for="seccion_id">Nivel</label>
                        <select id="seccion_id" name="seccion_id">
                            <option value="">(Seleccione uno)</option>
                            @foreach($secciones as $s)
                                <option value="{{ $s->id }}" @selected((string) old('seccion_id', $grado->seccion_id) === (string) $s->id)>{{ $s->nombre }}</option>
                            @endforeach
                        </select>

                        <label for="orden">Orden</label>
                        <input id="orden" name="orden" type="number" min="0" value="{{ old('orden', $grado->orden) }}">

                        <label for="is_active">Estado</label>
                        <select id="is_active" name="is_active">
                            <option value="1" @selected((int) old('is_active', $grado->is_active) === 1)>Activo</option>
                            <option value="0" @selected((int) old('is_active', $grado->is_active) === 0)>Inactivo</option>
                        </select>
                    </div>

                    <div class="actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.general.grados.item', ['item' => 'todos']) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

