﻿@extends('admin.layouts.app')

@section('title', 'Cursos')
@section('page_title', 'Cursos')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:8px 0 14px; font-weight:800; }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:1040px; margin:0 auto; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:15px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .legacy-table a { color:#005f84; text-decoration:underline; }
        .col-nivel { white-space: nowrap; }
        .total { max-width:1040px; margin:4px auto 0; text-align:right; font-size:13px; }
        .actions { text-align:center; margin-top:16px; }
        .btn-legacy {
            display:inline-flex; align-items:center; justify-content:center;
            min-width:90px; height:32px; padding:0 14px;
            border-radius:6px; border:1px solid #9a7205;
            background:#d9a10c; color:#fff; font-weight:700; text-decoration:none;
            box-shadow:0 1px 0 rgba(255,255,255,.35) inset, 0 2px 6px rgba(0,0,0,.2);
        }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Cursos</h2>

        <div class="table-box">
            <div class="table-title ui-table-title">Cursos</div>
            <table class="legacy-table ui-table">
                <thead>
                <tr>
                    <th>Nombre</th>
                    <th style="width:160px;">Nivel</th>
                    <th style="width:200px;">Cantidad de estudiantes</th>
                    <th style="width:300px;">Director</th>
                </tr>
                </thead>
                <tbody>
                @forelse($rows as $r)
                    <tr>
                        <td><a href="{{ route('admin.general.cursos.show', ['id' => $r->id, 'annio' => request('annio', date('Y'))]) }}">{{ $r->nombre }}</a></td>
                        <td class="col-nivel">{{ $r->nivel }}</td>
                        <td>{{ (int) $r->tot_estudiantes }}</td>
                        <td>{{ $r->director }}</td>
                    </tr>
                @empty
                    <tr><td colspan="4">Sin cursos registrados.</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="total ui-total">Total registros: {{ $rows->count() }}</div>

        <div class="actions">
            <a href="{{ route('admin.general.cursos.create', ['annio' => request('annio', date('Y'))]) }}" class="btn-legacy">Agregar</a>
        </div>
    </div>
@endsection

