﻿@extends('admin.layouts.app')

@section('title', 'Detalle de Curso')
@section('page_title', 'Detalle de Curso')

@section('content')
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-size:36px; font-size:34px; font-size:26px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; max-width: 980px; margin: 0 auto; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:14px; }
        .req-mark { float:right; color:#d98b00; font-style:italic; font-weight:700; margin-top:2px; }
        .form-grid { display:grid; grid-template-columns: 100px 1fr; gap:10px 12px; max-width:600px; align-items:center; }
        .form-grid label { font-weight:700; font-size:30px; font-size:15px; }
        .form-grid input, .form-grid select { width:100%; height:30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .btn-row { margin:14px 0 10px; display:flex; gap:14px; justify-content:center; }
        .btn-legacy {
            background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700;
            min-width:88px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px;
            display:inline-flex; align-items:center; justify-content:center; text-decoration:none;
            box-shadow:0 1px 0 rgba(255,255,255,.35) inset, 0 2px 6px rgba(0,0,0,.2);
        }
        .students-title { text-align:center; color:#0d6f88; margin:18px 0 10px; letter-spacing:8px; text-transform:uppercase; font-size:30px; font-size:15px; font-weight:800; }
        .students-box { border:2px solid #0e7a96; background:#fff; }
        .students-table { width:100%; border-collapse:collapse; }
        .students-table th, .students-table td { border:1px solid #95a5ad; padding:6px; font-size:14px; }
        .students-table th { background:#d5dddd; font-weight:800; text-align:left; }
        .students-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .avatar { width:48px; height:64px; border:1px solid #b6bfc7; object-fit:cover; background:#f5f5f5; display:block; }
        .avatar-fallback { width:48px; height:64px; border:1px solid #b6bfc7; background:linear-gradient(180deg,#f4f8fb,#dfe6eb); }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main">Detalle de Curso</h2>

        @if(session('status'))
            <div style="max-width:980px;margin:0 auto 10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif
        @if($errors->any())
            <div style="max-width:980px;margin:0 auto 10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <strong>Revisa estos campos:</strong>
                <ul style="margin:6px 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Curso</div>
            <div class="box-body">
                <div class="req-mark">* Requerido</div>
                <form method="POST" action="{{ route('admin.general.cursos.update', ['id' => $course->id, 'annio' => $annio]) }}">
                    @csrf
                    <div class="form-grid">
                        <label>Nombre</label>
                        <input value="{{ $course->nombre }}" disabled>

                        <label>Director</label>
                        <select name="director_id">
                            <option value="">(Seleccione uno)</option>
                            @foreach($docentes as $d)
                                @php($fullName = trim(($d->nombres ?? '') . ' ' . ($d->apellido1 ?? '') . ' ' . ($d->apellido2 ?? '')))
                                <option value="{{ (int) $d->id }}" @selected((int) old('director_id', $course->director_id) === (int) $d->id)>{{ $fullName }}</option>
                            @endforeach
                        </select>

                    </div>

                    <div class="btn-row">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.general.cursos.item', ['item' => 'todos', 'annio' => $annio]) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>

                <h3 class="students-title">Lista de Estudiantes</h3>
                <div class="students-box">
                    <table class="students-table">
                        <thead>
                        <tr>
                            <th>Nombre</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($students as $s)
                            @php($fullName = trim(($s->nombres ?? '') . ' ' . ($s->apellido1 ?? '') . ' ' . ($s->apellido2 ?? '')))
                            <tr>
                                <td>
                                    <div style="display:flex;gap:10px;align-items:center;">
                                        @if(!empty($s->photo))
                                            <img class="avatar" src="{{ asset('storage/' . $s->photo) }}" alt="{{ $fullName }}">
                                        @else
                                            <div class="avatar-fallback"></div>
                                        @endif
                                        <a href="{{ route('admin.estudiantes.show', ['id' => $s->id, 'annio' => $annio]) }}" style="color:#005c83;">{{ $fullName }}</a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td>Sin estudiantes en este curso.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

