@extends('admin.layouts.app')

@section('title', 'Detalle de Curso')
@section('page_title', 'Detalle de Curso')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:8px 0 14px; font-weight:800; }
        .panel { border:2px solid #0e7a96; background:#fff; max-width:1040px; margin:0 auto; }
        .panel-head { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .panel-body { padding:14px; }
        .grid {
            display:grid;
            grid-template-columns: 180px 1fr;
            gap:10px 14px;
            max-width:760px;
        }
        .grid label {
            font-weight:700;
            align-self:center;
            font-size: var(--fs-label-global);
        }
        .txt, .sel {
            width:100%;
            height:32px;
            border:1px solid #1e82aa;
            background:#c7d8db;
            padding:4px 8px;
            font-size: var(--fs-input-global);
        }
        .check-wrap { display:flex; align-items:center; gap:8px; height:32px; }
        .actions {
            margin-top:16px;
            display:flex;
            gap:12px;
            justify-content:center;
        }
        .btn-legacy {
            display:inline-flex; align-items:center; justify-content:center;
            min-width:90px; height:32px; padding:0 14px;
            border-radius:6px; border:1px solid #9a7205;
            background:#d9a10c; color:#fff; font-weight:700; text-decoration:none;
            font-size: var(--fs-button-global);
            box-shadow:0 1px 0 rgba(255,255,255,.35) inset, 0 2px 6px rgba(0,0,0,.2);
            cursor:pointer;
        }
        .errors {
            max-width:1040px;
            margin:0 auto 12px;
            background:#fff4d8;
            border:1px solid #e7c46a;
            color:#5c4300;
            padding:10px 12px;
        }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Detalle de Curso</h2>

        @if ($errors->any())
            <div class="errors">
                <strong>Corrige los siguientes campos:</strong>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="panel">
            <div class="panel-head ui-table-title">Detalle de Curso</div>
            <div class="panel-body">
                <form method="POST" action="{{ route('admin.general.cursos.store', ['annio' => $annio]) }}">
                    @csrf

                    <div class="grid">
                        <label for="nombre">Nombre</label>
                        <input id="nombre" name="nombre" class="txt" type="text" value="{{ old('nombre') }}" required>

                        <label for="grado_id">Grado</label>
                        <select id="grado_id" name="grado_id" class="sel">
                            <option value="">(Seleccione uno)</option>
                            @foreach($grados as $g)
                                <option value="{{ $g->id }}" @selected((string) old('grado_id') === (string) $g->id)>
                                    {{ $g->nombre }} {{ $g->nivel ? '- '.$g->nivel : '' }}
                                </option>
                            @endforeach
                        </select>

                        <label for="director_id">Director</label>
                        <select id="director_id" name="director_id" class="sel">
                            <option value="">(Seleccione uno)</option>
                            @foreach($docentes as $d)
                                @php($nombreDoc = trim(($d->nombres ?? '').' '.($d->apellido1 ?? '').' '.($d->apellido2 ?? '')))
                                <option value="{{ $d->id }}" @selected((string) old('director_id') === (string) $d->id)>{{ $nombreDoc }}</option>
                            @endforeach
                        </select>

                        <label for="position">Orden</label>
                        <input id="position" name="position" class="txt" type="number" min="0" max="9999" value="{{ old('position') }}">

                        <label for="is_active">Estado</label>
                        <div class="check-wrap">
                            <input id="is_active" name="is_active" type="checkbox" value="1" @checked(old('is_active', 1))>
                            <span>Activo</span>
                        </div>
                    </div>

                    <div class="actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.general.cursos.item', ['item' => 'todos', 'annio' => $annio]) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
