﻿@extends('admin.layouts.app')

@section('title', 'Estudiantes')
@section('page_title', 'General - Estudiantes')

@section('content')
    <style>
        .legacy-wrap { background: #efefef; border: 1px solid #d0d0d0; padding: 16px 14px 22px; }
        .legacy-title { text-align: center; color: #00607f; font-size: 20px; margin: 8px 0 18px; font-weight: 800; }
        .legacy-form .row {
            display: grid;
            grid-template-columns: 160px minmax(220px, 1fr) 100px minmax(140px, .8fr) 170px minmax(220px, 1fr);
            gap: 8px;
            align-items: center;
            margin-bottom: 8px;
        }
        .legacy-form label { font-weight: 700; color: #111; font-size: 13px; }
        .legacy-form label { white-space: nowrap; }
        .legacy-form input, .legacy-form select { background: #d9e7e7; border: 1px solid #08708e; border-radius: 0; height: 30px; padding: 4px 8px; }
        .legacy-form #nombres { max-width: 360px; }
        .legacy-form #codigo { width: 120px; }
        .legacy-form #documento { max-width: 300px; }
        .btn-legacy { background: #d9a10c; border: 1px solid #9a7205; color: #fff; font-weight: 700; min-width: 110px; height: 32px; border-radius: 6px; }
        .table-box { margin-top: 18px; border: 2px solid #0e7a96; background: #fff; }
        .table-title { background: #0e6f88; color: #fff; padding: 4px 4px; font-weight: 800; letter-spacing: 2px; text-transform: uppercase; font-size: 12px}
        .legacy-table { width: 100%; border-collapse: collapse; }
        .legacy-table th, .legacy-table td { border: 1px solid #95a5ad; padding: 6px; font-size: 14px; }
        .legacy-table th { background: #d5dddd; font-weight: 800; text-align: left; }
        .avatar { width: 54px; height: 68px; border: 1px solid #b6bfc7; object-fit: cover; background: #f5f5f5; display: block; }
        .avatar-fallback { width: 54px; height: 68px; border: 1px solid #b6bfc7; background: linear-gradient(180deg,#f4f8fb,#dfe6eb); }
        .parents { line-height: 1.2; font-size: 14px; }
        .parents .line { margin-bottom: 4px; white-space: nowrap; }
        .parents .line:last-child { margin-bottom: 0; }
        .wa-link { color: #0a7a49; text-decoration: none; font-weight: 700; }
        .wa-link:hover { text-decoration: underline; }
        .wa-icon { color: #25d366; margin-right: 4px; }
        .tfoot { text-align: right; font-size: 13px; margin-top: 6px; color: #222; }
        .actions-bottom { margin-top: 14px; text-align: center; }
        .pagination { margin-top: 10px; }
        .pager { margin-top: 12px; display: flex; justify-content: center; gap: 6px; flex-wrap: wrap; }
        .pager a, .pager span {
            border: 1px solid #8da0ad;
            background: #fff;
            color: #0e2b3d;
            text-decoration: none;
            padding: 4px 9px;
            border-radius: 4px;
            font-size: 13px;
            line-height: 1.2;
        }
        .pager .active {
            background: #0e6f88;
            border-color: #0e6f88;
            color: #fff;
            font-weight: 700;
        }
        .pager .disabled {
            opacity: .45;
            pointer-events: none;
        }
        @media (max-width: 1080px) {
            .legacy-form .row { grid-template-columns: 1fr; }
        }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Estudiantes matriculados en el año {{ $annio }}</h2>

        <form class="legacy-form" method="GET">
            <input type="hidden" name="annio" value="{{ $annio }}">
            <div class="row">
                <label for="curso">Curso</label>
                <select id="curso" name="curso">
                    <option value="">(Todos)</option>
                    @foreach($cursos as $c)
                        <option value="{{ $c->id }}" @selected((string)$curso === (string)$c->id)>{{ $c->nombre }}</option>
                    @endforeach
                </select>
                <div></div>
                <button type="submit" class="btn-legacy">Buscar</button>
                <div></div>
                <button type="button" class="btn-legacy">Agregar</button>
            </div>
            <div class="row">
                <label for="nombres">Nombres/Apellidos</label>
                <input id="nombres" name="nombres" value="{{ $nombres }}">
                <label for="codigo" style="text-align:right;">Código</label>
                <div style="display:flex;align-items:center;gap:4px;">
                    <span>WS-</span>
                    <input id="codigo" name="codigo" value="{{ $codigo }}">
                </div>
                <label for="documento" style="text-align:right;">No. de Documento</label>
                <input id="documento" name="documento" value="{{ $documento }}">
            </div>
        </form>

        <div class="table-box">
            <div class="table-title ui-table-title">Estudiantes matriculados en el año {{ $annio }}</div>
            <table class="legacy-table ui-table">
                <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Código</th>
                    <th>No. de Documento</th>
                    <th>Edad</th>
                    <th>Curso</th>
                    <th>Saldo Pendiente</th>
                    <th>Información Padres</th>
                </tr>
                </thead>
                <tbody>
                @forelse($rows as $r)
                    @php
                        $fullName = trim($r->nombres . ' ' . $r->apellido1 . ' ' . $r->apellido2);
                        $codigoView = 'WS-' . str_pad((string) ((int) ($r->contabilidad_id ?: $r->id)), 4, '0', STR_PAD_LEFT);
                        $edad = $r->fecha_nac ? \Carbon\Carbon::parse($r->fecha_nac)->age . ' años' : '-';
                        $saldo = (int) $r->is_deudor === 1 ? 'Pendiente' : '$ 0';
                        $madreName = trim((string) ($r->madre ?? ''));
                        $madreTel = trim((string) ($r->madre_tel_1 ?? ''));
                        $padreName = trim((string) ($r->padre ?? ''));
                        $padreTel = trim((string) ($r->padre_tel_1 ?? ''));
                        $madreDigits = preg_replace('/\D+/', '', $madreTel);
                        $padreDigits = preg_replace('/\D+/', '', $padreTel);
                        if ($madreDigits !== '' && strlen($madreDigits) <= 10) { $madreDigits = '57' . $madreDigits; }
                        if ($padreDigits !== '' && strlen($padreDigits) <= 10) { $padreDigits = '57' . $padreDigits; }
                        $madreWa = $madreDigits !== '' ? 'https://wa.me/' . $madreDigits : null;
                        $padreWa = $padreDigits !== '' ? 'https://wa.me/' . $padreDigits : null;
                    @endphp
                    <tr>
                        <td>
                            <div style="display:flex;gap:10px;align-items:center;">
                                @if(!empty($r->photo))
                                    <img class="avatar" src="{{ asset('storage/' . $r->photo) }}" alt="{{ $fullName }}">
                                @else
                                    <div class="avatar-fallback"></div>
                                @endif
                                <a href="{{ route('admin.estudiantes.show', ['id' => $r->id, 'annio' => $annio]) }}" style="color:#005c83;">{{ $fullName }}</a>
                            </div>
                        </td>
                        <td>{{ $codigoView }}</td>
                        <td>{{ $r->documento }}</td>
                        <td>{{ $edad }}</td>
                        <td>{{ $r->curso_nombre ?: '-' }}</td>
                        <td>{{ $saldo }}</td>
                        <td>
                            <div class="parents">
                                @if($madreName !== '' || $madreTel !== '')
                                    <div class="line">
                                        {{ $madreName !== '' ? $madreName : 'Madre' }}
                                        [
                                        @if($madreWa)
                                            <a class="wa-link" href="{{ $madreWa }}" target="_blank" rel="noopener noreferrer">
                                                <span class="wa-icon">WA</span>{{ $madreTel }}
                                            </a>
                                        @else
                                            {{ $madreTel !== '' ? $madreTel : '-' }}
                                        @endif
                                        ]
                                    </div>
                                @endif
                                @if($padreName !== '' || $padreTel !== '')
                                    <div class="line">
                                        {{ $padreName !== '' ? $padreName : 'Padre' }}
                                        [
                                        @if($padreWa)
                                            <a class="wa-link" href="{{ $padreWa }}" target="_blank" rel="noopener noreferrer">
                                                <span class="wa-icon">WA</span>{{ $padreTel }}
                                            </a>
                                        @else
                                            {{ $padreTel !== '' ? $padreTel : '-' }}
                                        @endif
                                        ]
                                    </div>
                                @endif
                                @if($madreName === '' && $madreTel === '' && $padreName === '' && $padreTel === '')
                                    <div class="line">Sin información</div>
                                @endif
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7">Sin registros para los filtros aplicados.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="tfoot">Total registros: {{ $rows->total() }}</div>
        <div class="actions-bottom"><button type="button" class="btn-legacy">Agregar</button></div>
        <div class="pager">
            @if($rows->onFirstPage())
                <span class="disabled">&laquo; Anterior</span>
            @else
                <a href="{{ $rows->previousPageUrl() }}">&laquo; Anterior</a>
            @endif

            @for($page = 1; $page <= $rows->lastPage(); $page++)
                @if(
                    $page === 1 ||
                    $page === $rows->lastPage() ||
                    ($page >= $rows->currentPage() - 2 && $page <= $rows->currentPage() + 2)
                )
                    @if($page === $rows->currentPage())
                        <span class="active">{{ $page }}</span>
                    @else
                        <a href="{{ $rows->url($page) }}">{{ $page }}</a>
                    @endif
                @elseif(
                    $page === $rows->currentPage() - 3 ||
                    $page === $rows->currentPage() + 3
                )
                    <span>...</span>
                @endif
            @endfor

            @if($rows->hasMorePages())
                <a href="{{ $rows->nextPageUrl() }}">Siguiente &raquo;</a>
            @else
                <span class="disabled">Siguiente &raquo;</span>
            @endif
        </div>
    </div>
@endsection

