@extends('admin.layouts.app')

@section('title', 'Dashboard')
@section('page_title', 'Dashboard')

@section('content')
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Manrope:wght@500;700;800&display=swap');
        .dash-wrap { font-family: "Manrope", "Segoe UI", sans-serif; display:grid; gap:14px; }
        .dash-hero {
            border: 1px solid #b8c9c4;
            border-radius: 14px;
            padding: 24px;
            background: linear-gradient(135deg, #c4d0c1 0%, #e9efea 55%, #ffffff 100%);
            position: relative;
            overflow: hidden;
        }
        .dash-hero::after {
            content: "";
            position: absolute;
            width: 280px;
            height: 280px;
            right: -90px;
            top: -110px;
            border-radius: 50%;
            background: rgba(9, 116, 146, .1);
        }
        .dash-title { margin:0; font-size:32px; color:#0d2b40; letter-spacing:-.02em; }
        .dash-sub { margin:8px 0 0; color:#335364; font-size:15px; }
        .dash-user {
            margin-top: 14px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background:#ffffffd9;
            border:1px solid #c7d6de;
            border-radius:999px;
            padding:8px 14px;
            color:#204153;
            font-weight:700;
            font-size:14px;
        }
        .dash-grid {
            display:grid;
            grid-template-columns: repeat(4, minmax(0, 1fr));
            gap:12px;
        }
        .dash-card {
            border:1px solid #b8c9d3;
            border-radius:12px;
            padding:14px;
            background:#fff;
            box-shadow: 0 8px 20px rgba(13, 53, 74, 0.06);
        }
        .dash-k { margin:0; font-size:12px; color:#5b7281; text-transform:uppercase; font-weight:700; letter-spacing:.06em; }
        .dash-v { margin:8px 0 0; font-size:34px; font-weight:800; color:#0e6f8f; line-height:1; }
        .dash-actions {
            border:1px solid #ced9e0;
            border-radius:12px;
            background:#fff;
            padding:14px;
        }
        .dash-actions h3 { margin:0 0 10px; font-size:16px; color:#183446; }
        .dash-links { display:flex; flex-wrap:wrap; gap:8px; }
        .dash-links a {
            text-decoration:none;
            border:1px solid #9fb9c8;
            color:#11455c;
            background:#eef6fa;
            border-radius:8px;
            padding:8px 12px;
            font-size:13px;
            font-weight:700;
        }
        .dash-links a:hover { background:#deedf5; }
        @media (max-width: 1024px) { .dash-grid { grid-template-columns: repeat(2, minmax(0, 1fr)); } }
        @media (max-width: 640px) { .dash-grid { grid-template-columns: 1fr; } .dash-title { font-size:26px; } }
    </style>

    @php
        $role = \Illuminate\Support\Str::lower((string) session('admin_role', ''));
        $links = [['Inicio', route('admin.dashboard')]];
        if (in_array($role, ['admin', 'superadmin', 'coordinadores', 'secretarias'], true)) {
            $links[] = ['Estudiantes', route('admin.estudiantes.index')];
            $links[] = ['Profesores', route('admin.profesores.index')];
        }
        if (in_array($role, ['admin', 'superadmin', 'coordinadores'], true)) {
            $links[] = ['Carga Académica', route('admin.academia.asignacion.item', ['item' => 'estado-actual'])];
            $links[] = ['Períodos', route('admin.academia.item', ['item' => 'periodos-academicos'])];
        }
        if (in_array($role, ['docentes', 'coordinadores'], true)) {
            $links[] = ['Dirección de grupo', route('admin.calificaciones.item', ['item' => 'curso-a-cargo'])];
        }
        $links[] = ['Observador', route('admin.observador.observaciones.index')];
    @endphp

    <div class="dash-wrap">
        <section class="dash-hero">
            <h2 class="dash-title">Panel de Control</h2>
            <p class="dash-sub">Bienvenido(a) a la plataforma del Colegio Windsor.</p>
            <div class="dash-user">Usuario: {{ session('admin_display_name', session('admin_email', 'Administrador')) }}</div>
        </section>

        <section class="dash-grid">
            @foreach($cards as $label => $value)
                <article class="dash-card">
                    <p class="dash-k">{{ $label }}</p>
                    <p class="dash-v">{{ number_format($value, 0, ',', '.') }}</p>
                </article>
            @endforeach
        </section>

        <section class="dash-actions">
            <h3>Accesos rápidos</h3>
            <div class="dash-links">
                @foreach($links as [$label, $url])
                    <a href="{{ $url }}">{{ $label }}</a>
                @endforeach
            </div>
        </section>
    </div>
@endsection
