@extends('admin.layouts.app')

@section('title', 'Cartera')
@section('page_title', 'Cartera')

@section('content')
    <div class="cards">
        @foreach($kpis as $label => $value)
            <div class="card">
                <div class="k">{{ $label }}</div>
                <div class="v">{{ number_format($value, 0, ',', '.') }}</div>
            </div>
        @endforeach
    </div>

    <div class="panel">
        <h3 style="margin-top:0;">Estudiantes con año pagado menor a {{ $year }}</h3>
        <table>
            <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Documento</th>
                <th>Año pagado</th>
                <th>Mes pagado</th>
                <th>Teléfono</th>
                <th>Email</th>
            </tr>
            </thead>
            <tbody>
            @forelse($rows as $r)
                <tr>
                    <td>{{ $r->id }}</td>
                    <td>{{ trim($r->nombres.' '.$r->apellido1.' '.$r->apellido2) }}</td>
                    <td>{{ $r->documento }}</td>
                    <td>{{ $r->annio_pagado }}</td>
                    <td>{{ $r->mes_pagado }}</td>
                    <td>{{ $r->telefono1 }}</td>
                    <td>{{ $r->email }}</td>
                </tr>
            @empty
                <tr><td colspan="7">Sin registros.</td></tr>
            @endforelse
            </tbody>
        </table>
    </div>
@endsection

