@extends('admin.layouts.app')

@section('title', 'Apertura de Notas')
@section('page_title', 'Apertura de Notas')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:10px 12px 18px; }
        .legacy-title { text-align:center; color:#006a8f; font-size:34px; margin:2px 0 10px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:4px; text-transform:uppercase; }
        .top-note { background:#f2e3b6; padding:10px 12px; margin:10px; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #7f919d; padding:6px; font-size:14px; line-height:1.1; }
        .legacy-table th { background:#c9d8d8; color:#000; text-align:left; font-weight:700; }
        .legacy-table tbody tr:nth-child(even) { background:#d6e2e2; }
        .status-pill {
            display:inline-block;
            min-width:110px;
            text-align:center;
            padding:3px 8px;
            border-radius:4px;
            font-weight:700;
            font-size:12px;
        }
        .status-on { background:#dff5e1; color:#0f6b2b; border:1px solid #93d19d; }
        .status-off { background:#ffe7e7; color:#8a1e1e; border:1px solid #f2adad; }
        .btn-toggle {
            border: 1px solid #8f6a00;
            border-radius: 6px;
            padding: 5px 10px;
            font-size: 12px;
            font-weight: 700;
            cursor: pointer;
            min-width: 98px;
            box-shadow: 0 1px 2px rgba(0,0,0,.2);
        }
        .btn-toggle-on { background:#dff5e1; color:#0f6b2b; border-color:#7bb487; }
        .btn-toggle-off { background:#ffe6c7; color:#8a4d00; border-color:#d6a25e; }
        .actions { text-align:center; margin-top:10px; }
        .btn-legacy {
            background:#d9a10c;
            border:1px solid #9a7205;
            color:#fff;
            font-weight:700;
            min-width:95px;
            height:32px;
            border-radius:6px;
            cursor:pointer;
            padding:0 18px;
            box-shadow:0 2px 3px rgba(0,0,0,.25);
        }
        .msg-ok { margin:0 0 10px; padding:8px 10px; background:#e7f7ea; border:1px solid #9dd5aa; color:#125323; }
        .msg-err { margin:0 0 10px; padding:8px 10px; background:#ffecec; border:1px solid #f0a2a2; color:#7d1111; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Apertura de Notas por Periodo</h2>

        @if(session('status'))
            <div class="msg-ok">{{ session('status') }}</div>
        @endif
        @if($errors->any())
            <div class="msg-err">
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Calificaciones - Fechas de Registro</div>
            <div class="top-note">
                <strong>Ano Academico Activo:</strong>
                <span style="margin-left:24px;font-weight:700;">{{ $annio }}</span>
            </div>

            <form method="POST" action="{{ route('admin.calificaciones.periodos_notas.save') }}" style="padding:0 10px 10px;">
                @csrf
                <input type="hidden" name="annio" value="{{ $annio }}">

                <table class="legacy-table ui-table">
                    <thead>
                        <tr>
                            <th style="width:35%;">Periodo</th>
                            <th style="width:19%;">Fecha Inicio Notas</th>
                            <th style="width:19%;">Fecha Fin Notas</th>
                            <th style="width:15%;">Estado</th>
                            <th style="width:12%;">Accion</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($rows as $row)
                            <tr>
                                <td>{{ $row->label }}</td>
                                <td>
                                    <input
                                        type="date"
                                        name="periodos[{{ $row->id }}][f_ini_notas]"
                                        value="{{ $row->f_ini_notas }}"
                                        style="width:100%;"
                                    >
                                </td>
                                <td>
                                    <input
                                        type="date"
                                        name="periodos[{{ $row->id }}][f_fin_notas]"
                                        value="{{ $row->f_fin_notas }}"
                                        style="width:100%;"
                                    >
                                </td>
                                <td>
                                    @if($row->habilitado)
                                        <span class="status-pill status-on">Habilitado</span>
                                    @else
                                        <span class="status-pill status-off">No habilitado</span>
                                    @endif
                                </td>
                                <td>
                                    <form method="POST" action="{{ route('admin.calificaciones.periodos_notas.toggle', ['id' => $row->id]) }}" style="margin:0;">
                                        @csrf
                                        <input type="hidden" name="annio" value="{{ $annio }}">
                                        <button type="submit" class="btn-toggle {{ $row->habilitado ? 'btn-toggle-on' : 'btn-toggle-off' }}">
                                            {{ $row->habilitado ? 'Deshabilitar' : 'Habilitar' }}
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5">No hay periodos registrados.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                <div class="actions">
                    <button type="submit" class="btn-legacy">Guardar</button>
                </div>
            </form>
        </div>
    </div>
@endsection
