﻿@extends('admin.layouts.app')

@section('title', 'Niveles de Calificaciones')
@section('page_title', 'Niveles de Calificaciones')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:10px 12px 18px; }
        .legacy-title { text-align:center; color:#006a8f; font-size:34px; margin:2px 0 10px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:4px; text-transform:uppercase; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #7f919d; padding:4px 6px; font-size:14px; line-height:1.1; }
        .legacy-table th { background:#c9d8d8; color:#000; text-align:left; font-weight:700; }
        .legacy-table tbody tr:nth-child(even) { background:#d6e2e2; }
        .legacy-table a { color:#005a7a; text-decoration:underline; }
        .total { text-align:right; font-size:13px; margin-top:6px; color:#000; }
        .actions { text-align:center; margin-top:10px; }
        .btn-legacy {
            background:#d9a10c;
            border:1px solid #9a7205;
            color:#fff;
            font-weight:700;
            min-width:95px;
            height:32px;
            border-radius:6px;
            cursor:pointer;
            padding:0 18px;
            box-shadow:0 2px 3px rgba(0,0,0,.25);
        }
        .btn-icon {
            width: 28px;
            height: 24px;
            border-radius: 4px;
            cursor: pointer;
            line-height: 1;
            padding: 0;
            font-size: 13px;
            font-weight: 700;
        }
        .btn-edit { border:1px solid #2b6a9a; color:#2b6a9a; background:#eef6ff; }
        .btn-delete { border:1px solid #9a2f2f; color:#9a2f2f; background:#fff2f2; }
        .msg-ok { margin:0 0 10px; padding:8px 10px; background:#e7f7ea; border:1px solid #9dd5aa; color:#125323; }
        .msg-err { margin:0 0 10px; padding:8px 10px; background:#ffecec; border:1px solid #f0a2a2; color:#7d1111; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Niveles de Calificaciones</h2>
        @if(session('status'))
            <div class="msg-ok">{{ session('status') }}</div>
        @endif
        @if($errors->any())
            <div class="msg-err">
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Niveles de Calificaciones</div>
            <table class="legacy-table ui-table">
                <thead>
                    <tr>
                        <th style="width:4%;">E</th>
                        <th style="width:4%;">X</th>
                        <th style="width:55%;">Nivel</th>
                        <th style="width:45%;">Rango</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($rows as $row)
                        <tr>
                            <td style="text-align:center;">
                                @if(!empty($row->editable))
                                    <a
                                        href="{{ route('admin.calificaciones.niveles.show', ['id' => (int) $row->id]) }}"
                                        class="btn-icon btn-edit"
                                        title="Editar"
                                        style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;"
                                    >&#9998;</a>
                                @endif
                            </td>
                            <td style="text-align:center;">
                                @if(!empty($row->editable))
                                    <button
                                        type="button"
                                        class="btn-icon btn-delete"
                                        onclick="deleteNivel({{ (int) $row->id }})"
                                        title="Eliminar"
                                    >&#128465;</button>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.calificaciones.niveles.show', ['id' => (int) $row->id]) }}">{{ $row->nombre }}</a>
                            </td>
                            <td>{{ $row->rango }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="total ui-total">Total registros: {{ $rows->count() }}</div>

        <div class="actions">
            <a href="{{ route('admin.calificaciones.niveles.create') }}" class="btn-legacy" style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;">Agregar</a>
        </div>
    </div>

    <form id="form-delete-nivel" method="POST" action="" style="display:none;">
        @csrf
    </form>

    <script>
        function deleteNivel(id) {
            if (!window.confirm('Seguro que deseas eliminar este nivel?')) return;
            const form = document.getElementById('form-delete-nivel');
            form.action = "{{ url('/admin/calificaciones/niveles') }}/" + id + "/eliminar";
            form.submit();
        }
    </script>
@endsection

