@extends('admin.layouts.app')

@section('title', 'Detalle de Calificacion')
@section('page_title', 'Detalle de Calificacion')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:14px 10px 20px; }
        .legacy-title { text-align:center; color:#00607f; font-size:39px; font-size:38px; margin:2px 0 12px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; max-width:980px; margin:0 auto; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:10px; }
        .req { text-align:right; color:#d98b00; font-style:italic; font-size:23px; font-size:22px; margin-bottom:8px; }
        .row { display:flex; align-items:center; gap:12px; flex-wrap:wrap; }
        .field { display:flex; align-items:center; gap:8px; }
        .field label { font-weight:700; min-width:70px; font-size:16px; }
        .field input { height:30px; border:1px solid #0f708e; border-radius:0; background:#cfe0e2; padding:3px 6px; font-size:16px; }
        .name-input { width:260px; }
        .small-input { width:76px; }
        .req-mark { color:#e69b1f; font-weight:700; }
        .actions { text-align:center; margin-top:36px; }
        .btn-legacy {
            background:#d9a10c;
            border:1px solid #9a7205;
            color:#fff;
            font-weight:700;
            min-width:90px;
            height:32px;
            border-radius:6px;
            cursor:pointer;
            padding:0 18px;
            box-shadow:0 2px 3px rgba(0,0,0,.25);
            margin:0 8px;
        }
        .msg-err { margin:0 auto 10px; max-width:980px; padding:8px 10px; background:#ffecec; border:1px solid #f0a2a2; color:#7d1111; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Detalle de Calificación</h2>

        @if($errors->any())
            <div class="msg-err">
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Calificación</div>
            <div class="box-body">
                <div class="req">* Requerido</div>

                <form method="POST" action="{{ $nivel ? route('admin.calificaciones.niveles.update', ['id' => $nivel->id]) : route('admin.calificaciones.niveles.store') }}">
                    @csrf
                    <div class="row">
                        <div class="field">
                            <label for="nombre">Nombre</label>
                            <input id="nombre" name="nombre" class="name-input" type="text" value="{{ old('nombre', $nivel->nombre ?? '') }}" required>
                            <span class="req-mark">*</span>
                        </div>

                        <div class="field" style="margin-left:40px;">
                            <label style="min-width:auto;">Rango:</label>
                        </div>

                        <div class="field">
                            <label for="desde" style="min-width:auto;">Desde</label>
                            <input id="desde" name="desde" class="small-input" type="number" step="1" min="0" max="100" value="{{ old('desde', $nivel->limite_inferior ?? '') }}" required>
                        </div>

                        <div class="field">
                            <label for="hasta" style="min-width:auto;">Hasta</label>
                            <input id="hasta" name="hasta" class="small-input" type="number" step="1" min="0" max="100" value="{{ old('hasta', $nivel->limite_superior ?? '') }}" required>
                            <span class="req-mark">*</span>
                        </div>
                    </div>

                    <div class="actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.calificaciones.item', ['item' => 'niveles-calificaciones']) }}" class="btn-legacy" style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

