@extends('admin.layouts.app')

@section('title', 'Dirección de grupo')
@section('page_title', 'Dirección de grupo')

@section('content')
    <style>
        .cc-wrap { background:#efefef; border:1px solid #d0d0d0; padding:12px; }
        .cc-title { text-align:center; color:#00607f; margin:4px 0 12px; font-weight:800; }
        .course-block { border:1px solid #9fc4d7; background:#f5fbff; color:#113247; margin-bottom:14px; }
        .course-head { padding:10px 12px; border-bottom:1px solid #c8ddea; background:#e6f4fb; display:flex; justify-content:space-between; align-items:center; gap:10px; flex-wrap:wrap; }
        .course-name { font-size:20px; font-weight:700; color:#0e5f82; }
        .student-card { padding:10px 12px; border-top:1px solid #4a4a4a; }
        .student-name { font-size:14px; color:#15465f; margin:0 0 8px; }
        .notes-wrap { width:100%; overflow-x:auto; overflow-y:hidden; padding-bottom:4px; }
        .notes-table { width:100%; border-collapse:collapse; background:#eef8fc; color:#143447; }
        .notes-table th, .notes-table td { border:1px solid #b9d8e6; padding:4px 6px; font-size: var(--fs-table-cell-global); text-align:center; }
        .notes-table th { background:#4f95b8; color:#fff; font-size: var(--fs-table-head-global); font-weight:700; }
        .notes-table th:first-child, .notes-table td:first-child { text-align:left; min-width:120px; position:sticky; left:0; z-index:2; background:#dceef7; }
        .notes-table th:nth-child(2), .notes-table td:nth-child(2) { position:sticky; left:120px; z-index:2; background:#dceef7; min-width:56px; }
        .notes-table thead th:first-child, .notes-table thead th:nth-child(2) { background:#4f95b8; z-index:3; }
        .chip { display:inline-flex; align-items:center; justify-content:center; min-width:38px; height:22px; background:#ffffff; color:#12384c; border:1px solid #98c7de; border-radius:3px; font-weight:400; }
        .empty { background:#fff; border:1px dashed #c9c9cc; color:#666; padding:8px; }
    </style>

    <div class="cc-wrap">
        <h2 class="cc-title ui-title">Dirección de grupo</h2>

        @if(!empty($isAdminView))
            <form method="GET" style="margin:0 0 12px;display:grid;grid-template-columns:120px 1fr;gap:8px;max-width:620px;">
                <input type="hidden" name="annio" value="{{ $annio }}">
                <label for="profesor" style="align-self:center;font-weight:700;">Docente</label>
                <select id="profesor" name="profesor" onchange="this.form.submit()" style="height:32px;border:1px solid #1e82aa;background:#d9e7e7;padding:4px 8px;">
                    <option value="">(Seleccione uno)</option>
                    @foreach($docentes as $d)
                        @php($n = trim(($d->nombres ?? '').' '.($d->apellido1 ?? '').' '.($d->apellido2 ?? '')))
                        @php($dirCursos = $directorCursosMap[(int) $d->id] ?? [])
                        <option value="{{ (int) $d->id }}" @selected((int) ($selectedDocente ?? 0) === (int) $d->id)>
                            {{ $n }}@if(!empty($dirCursos)) - Director(a): {{ implode(', ', $dirCursos) }}@endif
                        </option>
                    @endforeach
                </select>
            </form>
        @elseif(!empty($docenteNombre))
            <div style="margin:0 0 12px;font-weight:700;">Docente: {{ $docenteNombre }}</div>
        @endif

        @if($courses->isEmpty())
            <div class="empty">
                @if(!empty($isAdminView) && (int) ($selectedDocente ?? 0) === 0)
                    Selecciona un docente para ver sus cursos a cargo.
                @else
                    No hay cursos asignados como director de grupo para el año {{ $annio }}.
                @endif
            </div>
        @else
            @foreach($courses as $course)
                <div class="course-block">
                    <div class="course-head">
                        <div class="course-name">Salon: {{ $course->nombre }}</div>
                        <div>Total estudiantes: {{ $course->students->count() }}</div>
                    </div>

                    @forelse($course->students as $idx => $st)
                        <div class="student-card">
                            <p class="student-name">No. {{ $idx + 1 }} {{ mb_strtoupper((string) $st->nombre) }} [{{ $st->codigo }}]</p>
                            <div class="notes-wrap">
                            <table class="notes-table ui-table">
                                <thead>
                                <tr>
                                    <th>Periodo</th>
                                    <th>Prom</th>
                                    @foreach($course->subjects as $subj)
                                        <th title="{{ $subj->nombre }}">{{ $subj->abrev }}</th>
                                    @endforeach
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($st->rows as $row)
                                    <tr>
                                        <td>{{ $row->periodo }}</td>
                                        <td><span class="chip">{{ $row->prom !== '' ? $row->prom : '0' }}</span></td>
                                        @foreach($row->values as $val)
                                            <td><span class="chip">{{ $val !== '' ? $val : '0' }}</span></td>
                                        @endforeach
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                            </div>
                        </div>
                    @empty
                        <div class="student-card">
                            <div class="empty">Este curso no tiene estudiantes activos.</div>
                        </div>
                    @endforelse
                </div>
            @endforeach
        @endif
    </div>
@endsection
