@extends('admin.layouts.app')

@section('title', 'Periodos Academicos')
@section('page_title', 'Periodos Academicos')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:14px 10px 20px; }
        .legacy-title { text-align:center; color:#00607f; font-size:36px; font-size:34px; margin:2px 0 12px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:10px; }
        .top-note { background:#f2e3b6; padding:12px 14px; margin:0 0 10px; }
        .req { text-align:right; color:#d98b00; font-style:italic; font-size:24px; font-size:22px; }
        .section { border:1px solid #c9d1d8; background:#f3f3f3; padding:10px; }
        .section-title { margin:0 0 10px; color:#be8a07; font-weight:800; letter-spacing:6px; text-transform:uppercase; font-size:26px; font-size:24px; }
        .help { background:#e4e9ea; padding:8px 10px; margin-bottom:8px; }
        .period-table { width:100%; border-collapse:collapse; border:2px solid #0f708e; background:#fff; }
        .period-table th, .period-table td { border:1px solid #7f919d; padding:6px; font-size:28px; font-size:15px; }
        .period-table th { background:#c9d8d8; text-align:left; }
        .period-table tbody tr:nth-child(even) { background:#d6e2e2; }
        .btn-delete {
            width: 28px;
            height: 24px;
            border: 1px solid #9a2f2f;
            border-radius: 4px;
            background: #fff2f2;
            color: #9a2f2f;
            cursor: pointer;
            line-height: 1;
            padding: 0;
            font-size: 14px;
        }
        .btn-edit {
            width: 28px;
            height: 24px;
            border: 1px solid #2b6a9a;
            border-radius: 4px;
            background: #eef6ff;
            color: #2b6a9a;
            cursor: pointer;
            line-height: 1;
            padding: 0;
            font-size: 14px;
        }
        .btn-delete:disabled {
            opacity: .45;
            cursor: not-allowed;
        }
        .actions { text-align:center; margin-top:14px; }
        .btn-legacy {
            background:#d9a10c;
            border:1px solid #9a7205;
            color:#fff;
            font-weight:700;
            min-width:110px;
            height:32px;
            border-radius:6px;
            cursor:pointer;
            padding:0 18px;
        }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Periodos Academicos</h2>
        @if(session('status'))
            <div style="margin-bottom:10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif
        <div class="box">
            <div class="box-head ui-box-head">Periodos Academicos</div>
            <div class="box-body">
                <div class="req">* Requerido</div>
                <div class="top-note">
                    <strong>Año Académico Activo:</strong>
                    <span style="margin-left:30px;font-weight:700;">{{ $annio }}</span>
                </div>

                <form method="POST" action="{{ route('admin.academia.periodos.save') }}">
                    @csrf
                    <input type="hidden" name="annio" value="{{ $annio }}">
                    <div class="section">
                        <h3 class="section-title">Informacion para Calificaciones</h3>
                        <div class="help">
                            Por favor seleccione los <strong>periodos academicos</strong> que desea tener habilitados para el registro de Calificaciones por parte de los
                            <strong>Profesores</strong>.
                        </div>

                        <table class="period-table">
                            <thead>
                                <tr>
                                    <th style="width:40px;">E</th>
                                    <th style="width:40px;">X</th>
                                    <th style="width:36px;"><input type="checkbox" id="all_periods"></th>
                                    <th>Periodo academico</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($periodos as $p)
                                    <tr>
                                        <td style="text-align:center;">
                                            @if($p['exists'])
                                                <button
                                                    type="button"
                                                    class="btn-edit"
                                                    title="Editar texto"
                                                    onclick="submitEditPeriodo({{ $p['numero'] }}, '{{ addslashes($p['display_label']) }}')"
                                                >&#9998;</button>
                                            @else
                                                <button type="button" class="btn-edit" disabled title="No existe">-</button>
                                            @endif
                                        </td>
                                        <td style="text-align:center;">
                                            @if($p['exists'])
                                                <button
                                                    type="submit"
                                                    class="btn-delete"
                                                    title="Eliminar periodo"
                                                    form="delete-periodo-{{ $p['numero'] }}"
                                                    onclick="return confirm('Seguro que quieres eliminar este periodo?');"
                                                >&#128465;</button>
                                            @else
                                                <button type="button" class="btn-delete" disabled title="No existe">-</button>
                                            @endif
                                        </td>
                                        <td>
                                            <input
                                                type="checkbox"
                                                name="periodos[]"
                                                value="{{ $p['numero'] }}"
                                                @checked(in_array($p['numero'], $enabled, true))
                                            >
                                        </td>
                                        <td>{{ $p['display_label'] }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="actions" style="display:flex;gap:12px;justify-content:center;align-items:center;flex-wrap:wrap;">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <button
                            type="submit"
                            class="btn-legacy"
                            formaction="{{ route('admin.academia.periodos.add') }}"
                            formmethod="POST"
                        >
                            Agregar periodo
                        </button>
                    </div>
                </form>

                @foreach($periodos as $p)
                    @if($p['exists'])
                        <form id="delete-periodo-{{ $p['numero'] }}" method="POST" action="{{ route('admin.academia.periodos.delete', ['numero' => $p['numero']]) }}" style="display:none;">
                            @csrf
                            <input type="hidden" name="annio" value="{{ $annio }}">
                        </form>
                    @endif
                @endforeach

                <form id="edit-periodo-form" method="POST" action="" style="display:none;">
                    @csrf
                    <input type="hidden" name="annio" value="{{ $annio }}">
                    <input type="hidden" name="texto_periodo" value="">
                </form>
            </div>
        </div>
    </div>

    <script>
        (function () {
            const all = document.getElementById('all_periods');
            if (!all) return;
            const boxes = Array.from(document.querySelectorAll('input[name="periodos[]"]'));
            const sync = () => all.checked = boxes.length > 0 && boxes.every(b => b.checked);
            all.addEventListener('change', () => boxes.forEach(b => b.checked = all.checked));
            boxes.forEach(b => b.addEventListener('change', sync));
            sync();
        })();

        function submitEditPeriodo(numero, currentText) {
            const value = window.prompt('Nuevo texto del periodo (max 20 caracteres):', currentText || '');
            if (value === null) return false;
            const clean = value.trim();
            if (clean.length === 0) {
                alert('Debes escribir un texto.');
                return false;
            }
            if (clean.length > 20) {
                alert('Maximo 20 caracteres.');
                return false;
            }
            const form = document.getElementById('edit-periodo-form');
            form.action = "{{ url('/admin/academia/periodos-academicos') }}/" + numero + "/editar";
            form.querySelector('input[name=\"texto_periodo\"]').value = clean;
            form.submit();
            return false;
        }
    </script>
@endsection

