@extends('admin.layouts.app')

@section('title', 'Asignaturas')
@section('page_title', 'Asignaturas')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:14px 10px 20px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:2px 0 12px; font-weight:800; }
        .tools { max-width: 1060px; margin: 0 auto 12px; display:flex; align-items:center; gap:10px; flex-wrap:wrap; }
        .tools label { font-weight:700; min-width:90px; }
        .tools select { width:150px; height:30px; border:1px solid #08708e; background:#d9e7e7; padding:4px 8px; }
        .btn-legacy { background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700; min-width:90px; height:32px; border-radius:6px; cursor:pointer; padding:0 14px; }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:1060px; margin:0 auto; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:15px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .name-link { color:#005c83; text-decoration:underline; text-underline-offset:2px; }
        .name-link:hover { color:#014d6d; }
        .pager { margin-top:10px; display:flex; justify-content:center; gap:6px; flex-wrap:wrap; }
        .pager a, .pager span {
            border:1px solid #8da0ad; background:#fff; color:#0e2b3d; text-decoration:none;
            padding:4px 9px; border-radius:4px; font-size:13px; line-height:1.2;
        }
        .pager .active { background:#0e6f88; border-color:#0e6f88; color:#fff; font-weight:700; }
        .pager .disabled { opacity:.45; pointer-events:none; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Asignaturas</h2>
        @if(session('status'))
            <div style="max-width:1060px;margin:0 auto 10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif

        <form class="tools ui-label" method="GET">
            <label for="grado">Grado</label>
            <select id="grado" name="grado">
                <option value="">(Todos)</option>
                @foreach($grados as $g)
                    <option value="{{ (int) $g->id }}" @selected((string)$grado === (string)$g->id)>{{ trim((string)$g->nombre) }}</option>
                @endforeach
            </select>
            <button type="submit" class="btn-legacy">Buscar</button>
            <a href="{{ route('admin.academia.asignaturas.create') }}" class="btn-legacy" style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;">Agregar</a>
        </form>

        <div class="table-box">
            <div class="table-title ui-table-title">Asignaturas</div>
            <table class="legacy-table ui-table">
                <thead>
                <tr>
                    <th>Nombre</th>
                    <th>Área Académica</th>
                </tr>
                </thead>
                <tbody>
                @forelse($rows as $r)
                    <tr>
                        <td><a href="{{ route('admin.academia.asignaturas.show', ['id' => (int) $r->id]) }}" class="name-link">{{ mb_strtoupper((string) $r->nombre) }}</a></td>
                        <td>{{ $r->area_nombre ? mb_strtoupper((string) $r->area_nombre) : '' }}</td>
                    </tr>
                @empty
                    <tr><td colspan="2">Sin asignaturas para los filtros aplicados.</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="pager">
            @if($rows->onFirstPage())
                <span class="disabled">&laquo; Anterior</span>
            @else
                <a href="{{ $rows->previousPageUrl() }}">&laquo; Anterior</a>
            @endif

            @for($page = 1; $page <= $rows->lastPage(); $page++)
                @if($page === 1 || $page === $rows->lastPage() || ($page >= $rows->currentPage()-2 && $page <= $rows->currentPage()+2))
                    @if($page === $rows->currentPage())
                        <span class="active">{{ $page }}</span>
                    @else
                        <a href="{{ $rows->url($page) }}">{{ $page }}</a>
                    @endif
                @elseif($page === $rows->currentPage()-3 || $page === $rows->currentPage()+3)
                    <span>...</span>
                @endif
            @endfor

            @if($rows->hasMorePages())
                <a href="{{ $rows->nextPageUrl() }}">Siguiente &raquo;</a>
            @else
                <span class="disabled">Siguiente &raquo;</span>
            @endif
        </div>
    </div>
@endsection

