@extends('admin.layouts.app')

@section('title', 'Asignacion Academica - Estado Actual')
@section('page_title', 'Asignacion Academica - Estado Actual')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; min-height: 220px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:8px 0 18px; font-weight:800; }
        .legacy-form { max-width: 700px; margin: 0 auto; }
        .legacy-form .row {
            display:grid;
            grid-template-columns: 130px 1fr 16px;
            gap:8px;
            align-items:center;
            margin-bottom:10px;
        }
        .legacy-form label { font-weight:700; color:#111; font-size:15px; }
        .legacy-form select { background:#d9e7e7; border:1px solid #08708e; border-radius:0; height:30px; padding:4px 8px; width:100%; }
        .req { color:#d98b00; font-weight:700; }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:980px; margin:12px auto 0; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:15px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .total { max-width:980px; margin:4px auto 0; text-align:right; font-size:13px; }
        .mini-link {
            display:inline-flex; align-items:center; justify-content:center;
            min-width:92px; height:24px; padding:0 8px;
            border:1px solid #7ea0b2; background:#f3f8fb; color:#0e5f82;
            text-decoration:none; font-size:12px; font-weight:700;
        }
        .mini-link:hover { background:#e3f0f7; }
        .period-links { display:flex; flex-wrap:wrap; gap:4px; }
        .period-chip {
            display:inline-flex; align-items:center; justify-content:center;
            min-width:34px; height:22px; padding:0 6px;
            border:1px solid #7ea0b2; background:#f3f8fb; color:#0e5f82;
            text-decoration:none; font-size:11px; font-weight:700;
        }
        .period-chip:hover { background:#e3f0f7; }
        .period-chip.is-active { background:#0e6f88; color:#fff; border-color:#0e6f88; }
        .indicator-box { border:2px solid #0e7a96; background:#fff; max-width:980px; margin:12px auto 0; }
        .indicator-head { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .indicator-body { padding:10px; }
        .indicator-item { margin-bottom:8px; }
        .indicator-item label { display:block; font-weight:700; margin-bottom:3px; }
        .indicator-item textarea {
            width:100%; min-height:54px; resize:vertical;
            border:1px solid #97aeb9; background:#f5fafc; padding:6px 8px;
            font-size: var(--fs-input-global);
        }
        .indicator-item textarea.is-readonly { background:#f2f7fa; cursor:pointer; }
        .indicator-item textarea.js-editable-indicador.is-readonly:hover {
            background:#e6f4ff;
            border-color:#5aa7d9;
        }
        .indicator-item textarea.is-editing { background:#fff; border-color:#0e6f88; }
        .indicator-actions { margin-top:6px; text-align:right; }
        .indicator-save {
            display:inline-block; border:1px solid #9a7300; background:#d9a106; color:#fff;
            font-size:12px; font-weight:700; padding:4px 10px; cursor:pointer;
        }
        .indicator-kind {
            display:inline-block;
            margin-left:6px;
            padding:1px 6px;
            font-size:11px;
            font-weight:700;
            border:1px solid #9bb8c8;
            background:#eef6fb;
            color:#285d78;
        }
        .new-indicator-box {
            border:1px solid #8ea4b0;
            background:#f7fbfd;
            padding:10px;
            margin:8px 0 12px;
        }
        .new-indicator-head {
            display:flex;
            align-items:center;
            justify-content:space-between;
            margin-bottom:8px;
        }
        .new-indicator-title { font-weight:800; color:#0e5f82; }
        .new-indicator-form .ni-row {
            display:grid;
            grid-template-columns: 120px 1fr;
            gap:8px;
            align-items:center;
            margin-bottom:8px;
        }
        .new-indicator-form select,
        .new-indicator-form input,
        .new-indicator-form textarea {
            width:100%;
            border:1px solid #97aeb9;
            background:#fff;
            padding:6px 8px;
            font-size: var(--fs-input-global);
        }
        .new-indicator-form textarea { min-height:72px; resize:vertical; }
        .new-indicator-toggle {
            border:1px solid #9a7300; background:#d9a106; color:#fff;
            font-size:12px; font-weight:700; padding:4px 10px; cursor:pointer;
        }
        .new-indicator-help { font-size:12px; color:#4a6575; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Asignación Académica - Estado Actual</h2>

        <form class="legacy-form" method="GET" id="estadoForm">
            <input type="hidden" name="annio" value="{{ $annio }}">
            <div class="row">
                <label for="profesor">Profesor</label>
                @if(!empty($isDocenteView))
                    <input type="hidden" name="profesor" value="{{ $profesor }}">
                    <div style="background:#d9e7e7;border:1px solid #08708e;height:30px;padding:4px 8px;display:flex;align-items:center;">
                        {{ $docenteNombre !== '' ? $docenteNombre : 'Docente actual' }}
                    </div>
                    <span></span>
                @else
                    <select id="profesor" name="profesor" onchange="document.getElementById('estadoForm').submit()">
                        <option value="">(Seleccione uno)</option>
                        @foreach($profesores as $p)
                            @php
                                $fullName = trim(($p->nombres ?? '') . ' ' . ($p->apellido1 ?? '') . ' ' . ($p->apellido2 ?? ''));
                            @endphp
                            <option value="{{ (int) $p->id }}" @selected((string)$profesor === (string)$p->id)>{{ $fullName }}</option>
                        @endforeach
                    </select>
                    <span class="req">*</span>
                @endif
            </div>
        </form>

        @if($profesor !== '')
            <div class="table-box">
                <div class="table-title ui-table-title">Asignación Académica - Estado Actual</div>
                <table class="legacy-table ui-table">
                    <thead>
                    <tr>
                        <th>Curso</th>
                        <th>Asignatura</th>
                        <th>No. Estudiantes</th>
                        <th>Indicadores</th>
                        <th>Notas</th>
                        <th>Intensidad Semanal</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($rows as $r)
                        <tr>
                            <td>{{ $r->curso_nombre }}</td>
                            <td>{{ mb_strtoupper((string) $r->asignatura_nombre) }}</td>
                            <td>{{ (int) ($r->no_estudiantes ?? 0) }}</td>
                            <td>
                                <div style="margin-bottom:4px;"><strong>Indicadores</strong></div>
                                <div class="period-links">
                                    @foreach($periodosIndicadores as $p)
                                        @php
                                            $isActivePeriod = (int) $cursoId === (int) ($r->salon_id ?? 0)
                                                && (int) $asignaturaId === (int) ($r->asignatura_id ?? 0)
                                                && (int) $periodoId === (int) ($p->id ?? 0);
                                        @endphp
                                        <a
                                            class="period-chip {{ $isActivePeriod ? 'is-active' : '' }}"
                                            href="{{ route('admin.academia.asignacion.item', [
                                                'item' => 'estado-actual',
                                                'annio' => (int) $annio,
                                                'profesor' => (string) $profesor,
                                                'curso_id' => (int) ($r->salon_id ?? 0),
                                                'asignatura_id' => (int) ($r->asignatura_id ?? 0),
                                                'periodo_id' => (int) ($p->id ?? 0),
                                            ]) }}#indicadores-detalle"
                                            title="Cargar {{ $p->label }}"
                                        >{{ $p->label }}</a>
                                    @endforeach
                                </div>
                            </td>
                            <td>
                                <a class="mini-link" href="{{ route('admin.calificaciones.item', ['item' => 'registro-calificaciones', 'annio' => $annio, 'profesor' => $profesor, 'curso' => (int) ($r->salon_id ?? 0), 'asignatura' => (int) ($r->asignatura_id ?? 0)]) }}">Notas</a>
                            </td>
                            <td>{{ (int) ($r->intensidad ?? 0) > 0 ? ((int) $r->intensidad) . 'h' : '' }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="6">Sin asignaciones para el profesor seleccionado.</td></tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
            <div class="total ui-total">Total registros: {{ $rows->count() }}</div>

            @if((int) $cursoId > 0 && (int) $asignaturaId > 0 && (int) $periodoId > 0)
                <div class="indicator-box" id="indicadores-detalle">
                    <div class="indicator-head ui-table-title">Indicadores de la asignatura seleccionada</div>
                    <div class="indicator-body">
                        @if($seleccionAsignatura)
                            <div style="margin-bottom:10px;">
                                <strong>Curso:</strong> {{ $seleccionAsignatura->curso_nombre }}
                                &nbsp;|&nbsp;
                                <strong>Asignatura:</strong> {{ mb_strtoupper((string) $seleccionAsignatura->asignatura_nombre) }}
                                &nbsp;|&nbsp;
                                <strong>Periodo:</strong>
                                {{ optional($periodosIndicadores->firstWhere('id', (int) $periodoId))->label ?? ('P' . (int) $periodoId) }}
                            </div>
                        @endif

                        @if((int) $periodoId > 0 && $seleccionAsignatura)
                            <div class="new-indicator-box">
                                <div class="new-indicator-head">
                                    <div class="new-indicator-title">Nuevo Indicador / Logro</div>
                                    <button type="button" class="new-indicator-toggle" id="btnToggleNuevoIndicador">Agregar indicador / logro</button>
                                </div>
                                <form method="POST" action="{{ route('admin.academia.asignacion.indicadores.store') }}" id="formNuevoIndicador" class="new-indicator-form" style="display:none;">
                                    @csrf
                                    <input type="hidden" name="annio" value="{{ (int) $annio }}">
                                    <input type="hidden" name="profesor" value="{{ (int) $profesor }}">
                                    <input type="hidden" name="curso_id" value="{{ (int) $cursoId }}">
                                    <input type="hidden" name="asignatura_id" value="{{ (int) $asignaturaId }}">
                                    <input type="hidden" name="periodo_id" value="{{ (int) $periodoId }}">
                                    <input type="hidden" name="return_url" value="{{ request()->fullUrl() }}">
                                    <div class="ni-row">
                                        <label for="nuevo_valorativo"><strong>Valorativo</strong></label>
                                        <select name="valorativo" id="nuevo_valorativo">
                                            <option value="Fortaleza">Fortaleza</option>
                                            <option value="Debilidad">Debilidad</option>
                                            <option value="Recomendación">Recomendación</option>
                                        </select>
                                    </div>
                                    <div class="ni-row">
                                        <label for="nuevo_codigo"><strong>Código</strong></label>
                                        <input type="text" id="nuevo_codigo" readonly value="{{ (string) ($suggestedCodigos['Fortaleza'] ?? 100) }}">
                                    </div>
                                    <div class="new-indicator-help">Fortaleza: 100-199 | Debilidad: 200-299 | Recomendación: 300-399</div>
                                    <div class="ni-row" style="margin-top:8px;">
                                        <label for="nuevo_concepto"><strong>Concepto</strong></label>
                                        <textarea name="concepto" id="nuevo_concepto" required></textarea>
                                    </div>
                                    <div class="indicator-actions">
                                        <button type="submit" class="indicator-save">Guardar</button>
                                    </div>
                                </form>
                            </div>
                        @endif

                        @if((int) $periodoId <= 0)
                            <div>Seleccione un periodo (P1, P2, P3...) en la columna Indicadores para cargar la informacion.</div>
                        @elseif($indicadoresSeleccionados->isEmpty())
                            <div>No hay indicadores activos para esta asignatura en el año {{ $annio }}.</div>
                        @else
                            @php
                                $bloques = [
                                    'Fortalezas' => $indicadoresFortalezas,
                                    'Debilidades' => $indicadoresDebilidades,
                                    'Recomendaciones' => $indicadoresRecomendaciones,
                                ];
                            @endphp
                            @foreach($bloques as $tituloBloque => $coleccion)
                                <div class="indicator-item" style="margin-bottom:14px;">
                                    <label>{{ $tituloBloque }}</label>
                                    @if($coleccion->isEmpty())
                                        <textarea readonly class="is-readonly">Sin {{ mb_strtolower((string) $tituloBloque) }} registradas para este periodo.</textarea>
                                    @else
                                        @foreach($coleccion as $ind)
                                            <form method="POST" action="{{ route('admin.academia.asignacion.indicadores.update', ['id' => (int) $ind->id]) }}" style="margin-bottom:8px;">
                                                @csrf
                                                <input type="hidden" name="return_url" value="{{ request()->fullUrl() }}">
                                                <label style="font-size:12px; margin-bottom:2px;">
                                                    Indicador {{ trim((string) ($ind->codigo ?? '')) !== '' ? $ind->codigo : '#' . (int) $ind->id }}
                                                    <span class="indicator-kind">{{ $tituloBloque }}</span>
                                                </label>
                                                <textarea
                                                    name="concepto"
                                                    readonly
                                                    class="is-readonly js-editable-indicador"
                                                    title="Haz clic para editar"
                                                >{{ trim((string) ($ind->concepto ?? '')) }}</textarea>
                                                <div class="indicator-actions">
                                                    <button type="submit" class="indicator-save">Guardar</button>
                                                </div>
                                            </form>
                                        @endforeach
                                    @endif
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
            @endif
        @endif
    </div>
    <script>
        document.querySelectorAll('.js-editable-indicador').forEach(function (el) {
            el.addEventListener('click', function () {
                if (el.hasAttribute('readonly')) {
                    el.removeAttribute('readonly');
                    el.classList.remove('is-readonly');
                    el.classList.add('is-editing');
                    el.focus();
                }
            });
        });

        (function () {
            var btn = document.getElementById('btnToggleNuevoIndicador');
            var form = document.getElementById('formNuevoIndicador');
            var valorativo = document.getElementById('nuevo_valorativo');
            var codigo = document.getElementById('nuevo_codigo');
            var nextCodes = {
                'Fortaleza': '{{ (int) ($suggestedCodigos['Fortaleza'] ?? 100) }}',
                'Debilidad': '{{ (int) ($suggestedCodigos['Debilidad'] ?? 200) }}',
                'Recomendación': '{{ (int) ($suggestedCodigos['Recomendación'] ?? 300) }}'
            };

            if (btn && form) {
                btn.addEventListener('click', function () {
                    form.style.display = form.style.display === 'none' ? 'block' : 'none';
                });
            }
            if (valorativo && codigo) {
                var updateCode = function () {
                    codigo.value = nextCodes[valorativo.value] || '';
                };
                valorativo.addEventListener('change', updateCode);
                updateCode();
            }
        })();

        @if((int) $periodoId > 0 && (int) $cursoId > 0 && (int) $asignaturaId > 0)
        (function () {
            var box = document.getElementById('indicadores-detalle');
            if (box) {
                box.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }
        })();
        @endif
    </script>
@endsection

