@extends('admin.layouts.app')

@section('title', 'Asignacion Academica por Curso')
@section('page_title', 'Asignacion Academica por Curso')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:18px 14px 28px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:8px 0 18px; font-weight:800; }
        .legacy-form { max-width: 760px; margin: 0 auto; }
        .legacy-form .row {
            display:grid;
            grid-template-columns: 130px 1fr 16px;
            gap:8px;
            align-items:center;
            margin-bottom:10px;
        }
        .legacy-form label { font-weight:700; color:#111; font-size:15px; }
        .legacy-form select { background:#d9e7e7; border:1px solid #08708e; border-radius:0; height:30px; padding:4px 8px; width:100%; }
        .req { color:#d98b00; font-weight:700; }
        .section-title { text-align:center; letter-spacing:6px; color:#0d6284; font-size:28px; font-weight:800; margin:14px 0 8px; }
        .help { max-width: 980px; margin: 0 auto 8px; }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:980px; margin:0 auto; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:5px 6px; font-size:15px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .actions { text-align:center; margin-top:14px; }
        .btn-legacy { background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700; min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px; }
        .total { max-width:980px; margin:4px auto 0; text-align:right; font-size:13px; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Asignación Académica por Curso</h2>
        @if(session('status'))
            <div style="max-width:980px;margin:0 auto 10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif

        <form class="legacy-form" method="GET" id="courseFilterForm">
            <input type="hidden" name="annio" value="{{ $annio }}">
            <div class="row">
                <label for="curso">Curso</label>
                <select id="curso" name="curso" onchange="document.getElementById('courseFilterForm').submit()">
                    <option value="">(Seleccione uno)</option>
                    @foreach($courses as $c)
                        <option value="{{ (int) $c->id }}" @selected((string)$curso === (string)$c->id)>
                            {{ $c->nombre }}
                        </option>
                    @endforeach
                </select>
                <span class="req">*</span>
            </div>
        </form>

        @if($curso !== '')
            <h3 class="section-title">PROFESORES</h3>
            <div class="help">Seleccione el <strong>profesor</strong> que dicta la <strong>asignatura</strong> correspondiente en el <strong>curso</strong> seleccionado:</div>

            <form method="POST" action="{{ route('admin.academia.asignacion.curso.save') }}">
                @csrf
                <input type="hidden" name="annio" value="{{ $annio }}">
                <input type="hidden" name="curso" value="{{ $curso }}">

                <div class="table-box">
                    <table class="legacy-table ui-table">
                        <thead>
                        <tr>
                            <th>Asignatura</th>
                            <th>Profesor</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($subjects as $s)
                            <tr>
                                <td>{{ mb_strtoupper((string) $s->nombre) }}</td>
                                <td>
                                    <select name="profesor_por_asignatura[{{ (int) $s->id }}]">
                                        <option value="">(Seleccione uno)</option>
                                        @foreach($profesores as $p)
                                            @php
                                                $fullName = trim(($p->nombres ?? '') . ' ' . ($p->apellido1 ?? '') . ' ' . ($p->apellido2 ?? ''));
                                            @endphp
                                            <option value="{{ (int) $p->id }}" @selected((int)($selectedBySubject[$s->id] ?? 0) === (int)$p->id)>{{ $fullName }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="2">No hay asignaturas para este curso.</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="total ui-total">Total registros: {{ $subjects->count() }}</div>

                <div class="actions">
                    <button type="submit" class="btn-legacy">Guardar</button>
                </div>
            </form>
        @endif
    </div>
@endsection

