@extends('admin.layouts.app')

@section('title', 'Detalle de Area Academica')
@section('page_title', 'Detalle de Area Academica')

@section('content')
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; max-width: 980px; margin: 0 auto; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-size:36px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:12px; }
        .req { text-align:right; color:#d98b00; font-style:italic; }
        .top-grid { display:grid; grid-template-columns: 1fr 180px; gap:16px; align-items:end; margin-bottom:12px; }
        .field label { display:block; font-weight:700; font-size:14px; margin-bottom:2px; }
        .field input, .field select { width:100%; height:30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .star { color:#d98b00; margin-left:4px; }
        .section-title { text-align:center; letter-spacing:6px; color:#0d6284; font-size:24px; font-weight:800; margin:8px 0 4px; }
        .sub-table { width:60%; min-width:420px; border-collapse:collapse; border:2px solid #0e7a96; background:#fff; }
        .sub-table th, .sub-table td { border:1px solid #95a5ad; padding:5px; font-size:14px; }
        .sub-table th { background:#c8d8d8; text-align:left; font-weight:800; }
        .btn-mini-del {
            width: 26px; height: 22px; border: 1px solid #9a2f2f; border-radius: 4px;
            background: #fff2f2; color: #9a2f2f; cursor: pointer; line-height: 1; padding: 0; font-size: 12px;
        }
        .add-asignatura { margin-top: 8px; display:flex; gap:8px; align-items:center; flex-wrap:wrap; }
        .add-asignatura select { min-width: 360px; height: 30px; border:1px solid #0a7391; background:#d9e7e7; padding:4px 8px; }
        .actions { margin:14px 0 4px; display:flex; justify-content:center; gap:18px; }
        .btn-legacy {
            background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700;
            min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px; text-decoration:none;
            display:inline-flex; align-items:center; justify-content:center;
        }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main">Detalle de Área Académica</h2>
        @if(session('status'))
            <div style="margin-bottom:10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div style="margin-bottom:10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <ul style="margin:0 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Area Academica</div>
            <div class="box-body">
                <div class="req">* Requerido</div>
                <form method="POST" action="{{ route('admin.academia.areas.update', ['id' => (int) $area->id]) }}">
                    @csrf
                    <div class="top-grid">
                        <div class="field">
                            <label>Nombre</label>
                            <div style="display:flex;align-items:center;">
                                <input name="nombre" value="{{ old('nombre', $area->nombre) }}">
                                <span class="star">*</span>
                            </div>
                        </div>
                        <div class="field">
                            <label>Posición en Boletín</label>
                            <select name="orden">
                                @for($i = 0; $i <= 20; $i++)
                                    <option value="{{ $i }}" @selected((int)old('orden', $area->orden) === $i)>{{ $i }}</option>
                                @endfor
                            </select>
                        </div>
                    </div>

                    <h3 class="section-title">ASIGNATURAS</h3>
                    <table class="sub-table">
                        <thead>
                        <tr>
                            <th style="width:34px;">X</th>
                            <th>Nombre</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($asignaturas as $as)
                            <tr>
                                <td style="text-align:center;">
                                    <form method="POST" action="{{ route('admin.academia.areas.asignaturas.remove', ['id' => (int) $area->id, 'asignaturaId' => (int) $as->id]) }}" style="margin:0;" onsubmit="return confirm('Quitar asignatura de esta area?');">
                                        @csrf
                                        <button type="submit" class="btn-mini-del" title="Quitar">&#128465;</button>
                                    </form>
                                </td>
                                <td>{{ mb_strtoupper((string) $as->nombre) }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="2">Sin asignaturas asociadas.</td></tr>
                        @endforelse
                        </tbody>
                    </table>

                    <div class="add-asignatura">
                        <form method="POST" action="{{ route('admin.academia.areas.asignaturas.add', ['id' => (int) $area->id]) }}" style="display:flex;gap:8px;align-items:center;flex-wrap:wrap;">
                            @csrf
                            <select name="asignatura_id">
                                <option value="">Seleccionar asignatura...</option>
                                @foreach($availableAsignaturas as $item)
                                    <option value="{{ (int) $item->id }}">
                                        {{ mb_strtoupper((string) $item->nombre) }}
                                        @if(!empty($item->abrev))
                                            ({{ $item->abrev }})
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                            <button type="submit" class="btn-legacy">Agregar Asignatura</button>
                        </form>
                    </div>

                    <div class="actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.academia.item', ['item' => 'areas-academicas']) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

