@extends('admin.layouts.app')

@section('title', 'Detalle de Area Academica')
@section('page_title', 'Detalle de Area Academica')

@section('content')
    <style>
        .detail-wrap { background:#efefef; border:1px solid #cdd5db; padding:14px; max-width:980px; margin:0 auto; }
        .h-main { text-align:center; color:#035f7b; margin:8px 0 12px; font-weight:800; }
        .box { border:2px solid #0f708e; background:#fff; }
        .box-head { background:#0d6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .box-body { padding:12px; }
        .req { text-align:right; color:#d98b00; font-style:italic; }
        .top-grid { display:grid; grid-template-columns: 1fr 180px; gap:16px; align-items:end; margin-bottom:12px; }
        .field label { display:block; font-weight:700; margin-bottom:2px; font-size: var(--fs-label-global); }
        .field input, .field select {
            width:100%;
            height:30px;
            border:1px solid #0a7391;
            background:#d9e7e7;
            padding:4px 8px;
            font-size: var(--fs-input-global);
        }
        .star { color:#d98b00; margin-left:4px; }
        .actions { margin:14px 0 4px; display:flex; justify-content:center; gap:18px; }
        .btn-legacy {
            background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700;
            min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px; text-decoration:none;
            display:inline-flex; align-items:center; justify-content:center; font-size: var(--fs-button-global);
        }
        @media (max-width: 900px) {
            .top-grid { grid-template-columns: 1fr; }
        }
    </style>

    <div class="detail-wrap">
        <h2 class="h-main ui-title">Detalle de Área Académica</h2>
        @if ($errors->any())
            <div style="margin-bottom:10px;padding:8px 10px;background:#fff3f3;border:1px solid #efb0b0;color:#8b1f1f;">
                <ul style="margin:0 0 0 18px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="box">
            <div class="box-head ui-box-head">Detalle de Area Academica</div>
            <div class="box-body">
                <div class="req">* Requerido</div>
                <form method="POST" action="{{ route('admin.academia.areas.add') }}">
                    @csrf
                    <div class="top-grid">
                        <div class="field">
                            <label>Nombre</label>
                            <div style="display:flex;align-items:center;">
                                <input name="nombre" value="{{ old('nombre') }}" required>
                                <span class="star">*</span>
                            </div>
                        </div>
                        <div class="field">
                            <label>Posición en Boletín</label>
                            <select name="orden">
                                @for($i = 0; $i <= 20; $i++)
                                    <option value="{{ $i }}" @selected((int) old('orden', 0) === $i)>{{ $i }}</option>
                                @endfor
                            </select>
                        </div>
                    </div>

                    <div class="actions">
                        <button type="submit" class="btn-legacy">Guardar</button>
                        <a href="{{ route('admin.academia.item', ['item' => 'areas-academicas']) }}" class="btn-legacy">Regresar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
