﻿@extends('admin.layouts.app')

@section('title', 'Areas Academicas')
@section('page_title', 'Areas Academicas')

@section('content')
    <style>
        .legacy-wrap { background:#efefef; border:1px solid #d0d0d0; padding:14px 10px 20px; }
        .legacy-title { text-align:center; color:#00607f; font-size:38px; margin:2px 0 12px; font-weight:800; }
        .table-box { border:2px solid #0e7a96; background:#fff; max-width:980px; margin:0 auto; }
        .table-title { background:#0e6f88; color:#fff; padding:6px 10px; font-weight:800; letter-spacing:2px; text-transform:uppercase; }
        .legacy-table { width:100%; border-collapse:collapse; }
        .legacy-table th, .legacy-table td { border:1px solid #95a5ad; padding:6px; font-size:15px; text-align:left; vertical-align:middle; }
        .legacy-table th { background:#d5dddd; font-weight:800; }
        .legacy-table tbody tr:nth-child(even) { background:#ccdbdd; }
        .name-link { color:#005c83; text-decoration:underline; text-underline-offset:2px; }
        .name-link:hover { color:#014d6d; }
        .btn-edit {
            width: 28px; height: 24px; border: 1px solid #2b6a9a; border-radius: 4px;
            background: #eef6ff; color: #2b6a9a; cursor: pointer; line-height: 1; padding: 0; font-size: 14px;
        }
        .btn-delete {
            width: 28px; height: 24px; border: 1px solid #9a2f2f; border-radius: 4px;
            background: #fff2f2; color: #9a2f2f; cursor: pointer; line-height: 1; padding: 0; font-size: 14px;
        }
        .actions { margin-top: 12px; text-align: center; }
        .btn-legacy {
            background:#d9a10c; border:1px solid #9a7205; color:#fff; font-weight:700;
            min-width:110px; height:32px; border-radius:6px; cursor:pointer; padding:0 18px;
        }
        .col-e { width:40px; text-align:center; }
        .col-x { width:40px; text-align:center; }
        .col-name { width:auto; }
        .col-pos { width:180px; }
    </style>

    <div class="legacy-wrap">
        <h2 class="legacy-title ui-title">Areas Academicas</h2>
        @if(session('status'))
            <div style="max-width:980px;margin:0 auto 10px;padding:8px 10px;background:#e7f7ea;border:1px solid #9dd5aa;color:#125323;">{{ session('status') }}</div>
        @endif

        <div class="table-box">
            <div class="table-title ui-table-title">Areas Academicas</div>
            <table class="legacy-table ui-table">
                <thead>
                <tr>
                    <th class="col-e">E</th>
                    <th class="col-x">X</th>
                    <th class="col-name">Nombre</th>
                    <th class="col-pos">Posicion en Boletin</th>
                </tr>
                </thead>
                <tbody>
                @forelse($areas as $area)
                    <tr>
                        <td style="text-align:center;">
                            <a href="{{ route('admin.academia.areas.show', ['id' => (int) $area->id]) }}" class="btn-edit" title="Editar area" style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;">&#9998;</a>
                        </td>
                        <td style="text-align:center;">
                            <button type="submit" class="btn-delete" title="Eliminar area"
                                form="delete-area-{{ (int) $area->id }}"
                                onclick="return confirm('Seguro que quieres eliminar esta area?');">&#128465;</button>
                        </td>
                        <td><a href="{{ route('admin.academia.areas.show', ['id' => (int) $area->id]) }}" class="name-link">{{ mb_strtoupper((string) $area->nombre) }}</a></td>
                        <td>{{ (int) $area->orden > 0 ? (int) $area->orden : '' }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4">Sin areas academicas registradas.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        <div class="actions">
            <a href="{{ route('admin.academia.areas.create') }}" class="btn-legacy" style="display:inline-flex;align-items:center;justify-content:center;text-decoration:none;">Agregar</a>
        </div>

        @foreach($areas as $area)
            <form id="delete-area-{{ (int) $area->id }}" method="POST" action="{{ route('admin.academia.areas.delete', ['id' => (int) $area->id]) }}" style="display:none;">
                @csrf
            </form>
        @endforeach

    </div>
@endsection

