<?php

use Illuminate\Foundation\Application;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

/*
|--------------------------------------------------------------------------
| Base Path Resolver
|--------------------------------------------------------------------------
|
| Soporta dos escenarios:
| - Local: public/ dentro del proyecto Laravel.
| - Hosting: index.php en public_html y app en ../windsor_app.
|
*/
$basePath = realpath(__DIR__.'/..') ?: __DIR__.'/..';

if (! file_exists($basePath.'/vendor/autoload.php')) {
    $windsorPath = realpath(__DIR__.'/../windsor_app');
    if ($windsorPath && file_exists($windsorPath.'/vendor/autoload.php')) {
        $basePath = $windsorPath;
    }
}

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = $basePath.'/storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require $basePath.'/vendor/autoload.php';

// Bootstrap Laravel and handle the request...
/** @var Application $app */
$app = require_once $basePath.'/bootstrap/app.php';

$app->handleRequest(Request::capture());
