<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class NotasController extends Controller
{
    public function index(Request $request)
    {
        $annio = (int) $request->query('annio', date('Y'));

        $rows = DB::table('sweb_notas_v2 as n')
            ->leftJoin('sweb_estudiantes as e', 'e.id', '=', 'n.estudiante_id')
            ->select(
                'n.id',
                'n.annio',
                'n.periodo_id',
                'n.grado_id',
                'n.salon_id',
                'n.asignatura_id',
                'n.estudiante_id',
                'n.nota_final',
                'n.definitiva',
                'n.plan_apoyo',
                DB::raw("CONCAT(COALESCE(e.nombres,''), ' ', COALESCE(e.apellido1,''), ' ', COALESCE(e.apellido2,'')) as estudiante")
            )
            ->where('n.annio', $annio)
            ->orderByDesc('n.id')
            ->paginate(25)
            ->withQueryString();

        $anios = DB::table('sweb_notas_v2')
            ->distinct()
            ->orderByDesc('annio')
            ->pluck('annio');

        return view('admin.notas.index', compact('rows', 'annio', 'anios'));
    }
}

