<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        $cards = [
            'Estudiantes' => DB::table('sweb_estudiantes')->where('is_active', 1)->count(),
            'Docentes' => DB::table('dm_user')
                ->whereRaw("TRIM(REPLACE(COALESCE(roll,''), '\n', '')) IN ('docentes','coordinadores')")
                ->where('is_active', 1)
                ->count(),
            'Cursos' => DB::table('sweb_salones')->where('is_active', 1)->count(),
            'Asignaturas' => DB::table('sweb_asignaturas')->where('is_active', 1)->count(),
        ];

        return view('admin.dashboard', compact('cards'));
    }
}
