<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class CarteraController extends Controller
{
    public function index()
    {
        $year = (int) date('Y');

        $kpis = [
            'Total estudiantes' => DB::table('sweb_estudiantes')->count(),
            'Con año pagado atrasado' => DB::table('sweb_estudiantes')->where('annio_pagado', '<', $year)->count(),
            'Mes pagado en 0' => DB::table('sweb_estudiantes')->where('mes_pagado', '=', 0)->count(),
            'Con email registrado' => DB::table('sweb_estudiantes')->whereNotNull('email')->where('email', '!=', '')->count(),
        ];

        $rows = DB::table('sweb_estudiantes')
            ->select('id', 'nombres', 'apellido1', 'apellido2', 'documento', 'annio_pagado', 'mes_pagado', 'telefono1', 'email')
            ->where('annio_pagado', '<', $year)
            ->orderBy('annio_pagado')
            ->limit(200)
            ->get();

        return view('admin.cartera.index', compact('kpis', 'rows', 'year'));
    }
}

